//
// XMLTest.cc
// ---------
// Testmodul for the XML parser
//
// by Bjoern Lemke, (C)opyright 2005 by Bjoern Lemke
//

#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/GetLongOpt.h>
#include <lfcbase/Exception.h>

#include "../src/XMLSuite.h"

#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#define USAGE "Usage:\n\n\
  Info:               xmltest [ --version ] [ --help ]\n\
  Stream Out:         xmltest --mode=streamout\n\
  Stream Out:         xmltest --mode=streamin --file=<infile>"

class MyInStream : public XMLInStream
{
    
public:
    
    MyInStream() {};
    ~MyInStream() {};
    
    void putFirst(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*>& dataList) {

	cout << "FIRST :" << endl;
	cout << "ParentName = " << pParent->getName() << endl;
	cout << "Name = " << name << endl;
	Attribute *pAttr = attrList.First();
	while ( pAttr )
	{
	    cout << "Attr = " << pAttr->getName() << " Value=" << pAttr->getValue() << endl;	    
	    pAttr = attrList.Next();
	}

	char** pData = dataList.First();
	while ( pData )
	{
	    cout << "Data = " << *pData << endl;	    
	    pData = dataList.Next();
	}

	// cout << "First Name is " << name << endl;
	// cout  << "DATA List Size = " << dataList.Size() << endl;
	// cout << " Data = " << *dataList.First() << endl;

	_rowCount=0;
    }
    
    void putNext(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*>& dataList) {
	
	cout << "Row " << _rowCount << " : " << endl;
	cout << "ParentName = " << pParent->getName() << endl;
	cout << "Name = " << name << endl;
	Attribute *pAttr = attrList.First();
	while ( pAttr )
	{
	    cout << "Attr = " << pAttr->getName() << " Value=" << pAttr->getValue() << endl;	    
	    pAttr = attrList.Next();
	}

	char** pData = dataList.First();
	while ( pData )
	{
	    cout << "Data = " << *pData << endl;	    
	    pData = dataList.Next();
	}
	
        _rowCount++;
	
	// cout  << "DATA List Size = " << dataList.Size() << endl;	
    }

private:

    int _rowCount;

};

class MyOutStream : public XMLOutStream {

public:

    MyOutStream() { _count=0; };
    ~MyOutStream() {};

    Element* getFirst() {
	
	Element *pE = new Element("StreamElement");
	pE->setAttribute(Chain("Iwan"), Chain("ddddd"));

	char* d = (char*)malloc(100);
	strcpy(d, "THIS IS THE first data ]]> with control token");
	pE->addData(d);
	d = (char*)malloc(100);
	strcpy(d, "THIS IS THE second data");
	pE->addData(d);

	return pE;
    }

    Element* getNext() {
	
	if ( _count < 3 )
	{
	    Element *pE = new Element("StreamElement");
	    pE->setAttribute(Chain("Iwan"), Chain(_count));
	    _count++;
	    return pE;
	}
	else
	{
	    return 0;
	}

    }
       
private:
    
    int _count;
    
};


void writeXML()
{

    XMLSuite xml;

    Document *pDoc = new Document("XMLTEST");
    pDoc->setAttribute(Chain("version"), Chain("1.0"));
    pDoc->setDocType("TESTDOC");

    xml.setDocument(pDoc);

    Element *pRoot = new Element("MYROOT");

    MyOutStream *pOutStream = new MyOutStream();

    pRoot->setOutStream(pOutStream);

    int i=0;
    while ( i < 3 )
    {
    Element *pSub = new Element("XSUB");

    pSub->setAttribute(Chain("Attr1"), Chain("Value1"));
    pSub->setAttribute(Chain("Attr2"), Chain("Value2"));
    pSub->setAttribute(Chain("Attr3"), Chain("Value3"));


    Element *pSubSub = new Element("XSUBSUB");
    pSubSub->setAttribute(Chain("Attr1"), Chain("Value1"));
    pSub->addContent(pSubSub);


    pSub->setText(Chain("This is text data content"));
    pRoot->addContent(pSub);
    i++;
    }

    pDoc->setRootElement(pRoot);

    Chain xmlChain;

    xml.getXMLChain( xmlChain );
    Chain fileName("sample.xml");
    File* pXMLFile = new File(fileName);

    pXMLFile->open(File::WRITE);

    pXMLFile->writeChain(xmlChain);

    pXMLFile->close();
    delete pXMLFile;
}


void readAndWriteXML()
{
    
    Chain fileName("sample.xml");
    
    File* pXMLFile = new File(fileName);
    
    pXMLFile->open(File::READ);
    
    XMLSuite xml;
    MyInStream* pInStream = new MyInStream;

    Document *pDoc = new Document("XMLTEST");
    pDoc->setAttribute(Chain("version"), Chain("1.0"));
    
    xml.setDocument(pDoc);    
    xml.setFile(pXMLFile);
    xml.setInStream(pInStream);
    
    xml.parse();
    	    
    // cout << "Parse finished" << endl;
    pXMLFile->close();
    delete pXMLFile;


    Chain outFile("sample-out.xml");
    File* pXMLOut = new File(outFile);

    pXMLOut->open(File::WRITE);

    Chain xmlChain;
    xml.getXMLChain( xmlChain );
    pXMLOut->writeChain(xmlChain);

    pXMLOut->close();

}

void cloneXML()
{

    Chain fileName("sample.xml");
    File xmlFile(fileName);
    xmlFile.open(File::READ);
    
    char readBuf[1024];
    Chain xmlDoc;
    
    int i;
    while (( i = xmlFile.readByte(readBuf, 1024)) > 0)
    {
	// cout << "Reading " << i << " bytes" << endl;
	xmlDoc = xmlDoc + Chain(readBuf, i); // .subChain(1,i);
    }
    
    xmlFile.close();
    
    Document *pDoc = new Document("XMLTEST");
    pDoc->setAttribute(Chain("version"), Chain("1.0"));
        
    XMLSuite xml((char*)xmlDoc);

    MyInStream* pInStream = new MyInStream;
    
    pDoc->clear();

    xml.setInStream(pInStream);
    xml.setDocument(pDoc);

    xml.parse();
    
    Element* pE = pDoc->getRootElement();
    
    Element* pClone = pE->createClone();

    pDoc->clear();
    
    Document *pCloneDoc = new Document("CLONETEST");
    pCloneDoc->setRootElement(pClone);
    XMLSuite xmlClone;
    xmlClone.setDocument(pCloneDoc);
    
    Chain xmlChain;
    // xmlClone.getXMLChain( xmlChain );
   
}

int main(int argc, char** argv)
{

    if ( argc == 1 )
    {
	int numCheck = 3;
	int checkCount = 1;
	
	try
	{
	    
	    cout << "1.." << numCheck << endl;
	    
	    writeXML();
	    cout << "ok " << checkCount << " - write xml" << endl;
	    checkCount++;
	    
	    readAndWriteXML();
	    cout << "ok " << checkCount << " - readwrite xml" << endl;
	    checkCount++;

	    cloneXML();	
	    cout << "ok " << checkCount << " - clone xml" << endl;
	    checkCount++;	
	    
	}
	catch (Exception e)
	{
	    Chain msg;
	    e.pop(msg);
	    cout << "not ok " << checkCount << " - " << msg << endl;
	}
    }
    else
    {

	Chain impFile(argv[1]);
	
        XMLSuite xml;
    
	File *pInFile = new File(impFile);
	MyInStream* pInStream = 0;
	Document *pDoc = new Document("XML_STREAM_TEST");
	
	try
	{	
	    pInFile->open(File::READ);
	    
	    pInStream = new MyInStream();
	    
	    // pDoc->setAttribute(XML_VERSION_ATTR, XML_VERSION_VALUE);
	
	    xml.setDocument(pDoc);    
	    xml.setFile(pInFile);
	    xml.setInStream(pInStream);
	
	    xml.parse();
	
	    if ( pInStream )
	    {
		delete pInStream;
		pInStream = 0;
	    }
	    pInFile->close();
	    delete pInFile;
	    pInFile = 0;
	}
	catch (Exception e)
	{
	    Chain msg;
	    e.pop(msg);
	    cout << "Error : " <<  msg << endl;
	}
    }

    
    exit(0);

}


