--
-- ### Clob reference checks
--

show systemspace;

drop if exists table t1;
create table t1 (a int,  b clob );

drop if exists table t2;
create table t2 (a clob );

insert into t1 values ( 1, 'THIS IS CLOB 1 XXXXXXXXXXXXXXX');
insert into t1 values ( 2, 'THIS IS CLOB 2');
insert into t1 values ( 3, 'THIS IS CLOB 3');
insert into t1 values ( 4, 'THIS IS CLOB 4');
insert into t1 values ( 5, 'THIS IS CLOB 5');
insert into t1 values ( 6, 'THIS IS CLOB 6');
insert into t1 values ( 7, 'THIS IS CLOB 7');

-- select * from t1;

update t1 set b = 'ANOTHER CLOB' where a = 3;

select a, clob2str(b) from t1;

select * from t1;

-- we copy clob references from t1 to t2
insert into t2 select b from t1;

-- just clob references are deleted, there are still references in t2 
delete from t1;
drop table t1;
show systemspace;

-- now clobs are deleted
drop table t2;

-- should be empty
show systemspace;
