#ifndef _CEGODATABASEFORMATER_H_INCLUDED_
#define _CEGODATABASEFORMATER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDatabaseFormater.h
// ----------------------
// Cego database formater super class
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDatabaseFormater
// 
// Description: Abstract class which is implemented by database specific database export classes 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoProcBlock.h"
#include "CegoDataType.h"
#include "CegoProcedure.h"
#include "CegoProcAssignStmt.h"
#include "CegoQuery.h"
#include "CegoSelect.h"
#include "CegoExpr.h"
#include "CegoTerm.h"
#include "CegoFactor.h"
#include "CegoFunction.h"
#include "CegoAggregation.h"
#include "CegoException.h"

class CegoDatabaseFormater {

public:
    
    CegoDatabaseFormater();
    ~CegoDatabaseFormater();
    
    virtual Chain formatProcedure(const Chain& procName, CegoProcedure::ProcType procType, CegoDataType returnType, int returnTypeLen, int returnTypeDim, CegoProcBlock* pBlock) = 0;
    virtual Chain formatProcVar(const Chain& varName, CegoProcVar::VarType varType, CegoDataType dt, int dtlen, int dtdim) = 0; 
    virtual Chain formatProcBlock(const ListT<CegoProcVar>& varList, const ListT<CegoProcStmt*>& stmtList,  const ListT<CegoProcException*>& exceptionList) = 0;
    virtual Chain formatProcAssignStmt(CegoProcAssignStmt::AssignmentMode mode, const Chain paramName, CegoExpr* pExpr) = 0;
    virtual Chain formatProcThrowStmt(CegoExpr* pExpr) = 0;
    virtual Chain formatProcBlockStmt(CegoProcBlock* pBlock) = 0;
    virtual Chain formatProcCursorCreateStmt(const Chain& name, CegoSelect* pSelect) = 0;
    virtual Chain formatProcCursorCloseStmt(const Chain& name) = 0;
    virtual Chain formatProcIfStmt(const ListT<CegoPredicate*>& predList, const ListT<CegoProcBlock*>& ifBlockList) = 0;
    virtual Chain formatProcNoopStmt() = 0;
    virtual Chain formatProcQueryStmt(CegoQuery *pQuery) = 0;
    virtual Chain formatProcReturnStmt(CegoExpr *pExpr) = 0;
    virtual Chain formatProcWhileStmt(CegoPredicate* pPred, CegoProcBlock* pBlock) = 0;
    virtual Chain formatProcException(CegoException excep) = 0;    
    virtual Chain formatExpr(CegoExpr::ExpType expType, CegoExpr* pExpr, CegoTerm* pTerm) = 0;
    virtual Chain formatTerm(CegoTerm::TermType termType, CegoTerm* pTerm, CegoFactor* pFactor) = 0;
    virtual Chain formatFactor(CegoFactor::FacType facType,
			       const CegoFieldValue& fv,
			       CegoAttrDesc* pAttrDesc,
			       const Chain varName,
			       CegoExpr* pExpr,
			       CegoProcFetch *pFetch,
			       CegoAggregation* pAggr,
			       CegoFunction* pFunction,
			       CegoSelect* pSelect,
			       CegoCaseCond* pCaseCond,
			       CegoCondition* pCond) = 0;
    virtual Chain formatSelect(CegoSelect::SelectMode mode,
			       bool isDistinct,
			       const ListT<CegoExpr*>& exprList,
			       const ListT<CegoContentObject*>& coList,
			       CegoPredicate *pPred,
			       ListT<CegoAttrDesc*> *pGroupList,
			       CegoPredicate* pHavingPred,
			       ListT<CegoExpr*> *pOrderList,
			       int rowLimit,
			       CegoSelect* pUnionSelect) = 0;
    virtual Chain formatProcFetch(const Chain& curName, const ListT<Chain>& varList) = 0;
    virtual Chain formatPred(CegoPredicate::CompMode mode,
			     CegoExpr* pExpr1,
			     CegoExpr *pExpr2,
			     CegoExpr* pExpr3,
			     ListT<CegoExpr*>& exprList,
			     CegoComparison comp,
			     const Chain& pattern,
			     CegoCondition* pCond,
			     CegoPredicate* pPred,
			     CegoSelect *pSelect) = 0;
    virtual Chain formatCondition(CegoCondition::CondType type,
				  CegoPredicate* pPred1,
				  CegoPredicate *pPred2) = 0;

    virtual Chain formatQuery(CegoQuery::QueryMode mode,
			      const Chain& tableName,
			      const Chain& tableAlias,
			      const ListT<CegoField>& schema,
			      const ListT<ListT<CegoExpr*> >& exprListArray,
			      const ListT<CegoExpr*>& updList,
			      const ListT<CegoReturnVar*>& retVarList,
			      const ListT<CegoAlterDesc>& alterList,
			      CegoPredicate *pPred,
			      CegoSelect *pSelect,
			      const Chain& objName,
			      CegoObject::ObjectType objType,
			      const Chain& newObjName) = 0;
    virtual Chain formatAttr(const Chain& tableName, const Chain& attrName) = 0;
    virtual Chain formatFunction(CegoFunction::FunctionType type, const ListT<CegoExpr*>& exprList, const Chain& funcName, const Chain& counterId) = 0;
    virtual Chain formatAggregation(CegoAggregation::AggType type, CegoExpr *pExpr, bool isDistinct) = 0;
    virtual Chain formatCaseCond(const ListT<CegoPredicate*>& predList, const ListT<CegoExpr*>& exprList, CegoExpr* elseExpr) = 0;
    virtual Chain formatReturnValue(const Chain& varName, CegoExpr* pExpr) = 0;
    virtual Chain formatAlter(CegoAlterDesc::AlterType type, const CegoField& f, const Chain& attrName) = 0;
    virtual Chain formatFieldValue(CegoDataType type, void *pV, int len ) = 0;
    virtual Chain formatTrigger(const Chain& triggerName,
				bool isBefore,
				bool isOnInsert,
				bool isOnUpdate,
				bool isOnDelete,
				const Chain& tableName,
				CegoProcBlock* pBlock) = 0;
};
#endif
