#ifndef _CEGOEXPOUTSTREAM_H_INCLUDED_
#define _CEGOEXPOUTSTREAM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoExpOutStream.h
// ------------------
// Cego export outstream description
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoExpOutStream
// 
// Description: Database XML and binary export handle
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcxml/Element.h>
#include <lfcxml/XMLOutStream.h>

// CEGO INCLUDES
#include "CegoDistManager.h"
#include "CegoAdminHandler.h"
#include "CegoObjectCursor.h"
#include "CegoField.h"

class CegoExpOutStream : public XMLOutStream {
    
public:
    
    CegoExpOutStream(int tabSetId, const Chain& tableName, const ListT<CegoField>& schema, CegoDistManager* pGTM, CegoAdminHandler* pAH = 0);
    ~CegoExpOutStream();

    unsigned long long numExported() const;
    
    Element* getFirst();
    Element* getNext();

private:

    Element* getRowElement(ListT<CegoField>& schema);
    
    CegoDistManager* _pGTM;
    CegoAdminHandler* _pAH;
    CegoObjectCursor* _pOC;
    ListT<CegoField> _schema;
    Chain _tableName;
    unsigned long long _rowCount;
    int _tabSetId;
};
#endif
