#ifndef _CEGOPROCBLOCKSTMT_H_INCLUDED_
#define _CEGOPROCBLOCKSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcBlockStmt.h  
// -------------------
// Cego procedure block statement block class definition
//              
// Design and Implementation by Bjoern Lemke
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcBlockStmt
// 
// Description: Stored procedure block statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"

class CegoProcBlockStmt : public CegoProcStmt {
    
public:

    CegoProcBlockStmt(CegoProcBlock *pBlock,
		      CegoProcBlock *pParentBlock);
    ~CegoProcBlockStmt();

    void setBlock(CegoProcBlock* pBlock);
    CegoException execute();
    void cleanUp();
    Chain toChain(int defTabSetId, const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    bool isStatic() const;
    
private:

    CegoProcBlock* _pBlock;
};
#endif
