///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursorCreateStmt.cc  
// ---------------------------                                                     
// Cego procedure cursor statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcCursorCreateStmt
//
// Description: Stored procedure statement for cursor creation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
// CEGO INCLUDES
#include "CegoSelect.h"
#include "CegoProcCursorCreateStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcCursorCreateStmt::CegoProcCursorCreateStmt(const Chain& name, CegoSelect *pSelect,
						   CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _name = name;
    _pSelect = pSelect;
}

CegoProcCursorCreateStmt::~CegoProcCursorCreateStmt()  
{
}

CegoException CegoProcCursorCreateStmt::execute()
{
    if ( _pSelect )
    {
	_pSelect->setProcBlock(getParentBlock());
	_pSelect->prepare();	
    }
    return NONE_EXCEP;
}

void CegoProcCursorCreateStmt::cleanUp()
{
    if ( _pSelect )
    {
	_pSelect->cleanUp();
    }
}

Chain CegoProcCursorCreateStmt::toChain(int defTabSetId, const Chain& indent) const
{
    Chain s;

    s += indent + Chain("cursor ");
    s += _name;
    s += Chain(" as\n");
    s += indent + _pSelect->toChain(defTabSetId, indent + Chain(DEFAULTINDENT));
    return s;
}

Chain CegoProcCursorCreateStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcCursorCreateStmt(_name, _pSelect);
}

bool CegoProcCursorCreateStmt::isStatic() const
{
    return false;
}
