#ifndef _CEGOPROCRETURNSTMT_H_INCLUDED_
#define _CEGOPROCRETURNSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcReturnStmt.h  
// --------------------
// Cego procedure return statement implementation
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcReturnStmt
// 
// Description: Stored procedure return statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcStmt.h"
#include "CegoExpr.h"
#include "CegoProcBlock.h"

class CegoProcReturnStmt : public CegoProcStmt  {
    
public:
    
    CegoProcReturnStmt(CegoProcBlock *pBlock);
    CegoProcReturnStmt(CegoExpr *pExpr, CegoProcBlock *pBlock);
    ~CegoProcReturnStmt();

    CegoException execute();
    void cleanUp();
    Chain toChain(int defTabSetId, const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    bool isStatic() const;
    
private:

    CegoExpr *_pExpr;
    CegoProcBlock *_pBlock;
};
#endif
