#ifndef _CEGOXPORTER_H_INCLUDED_
#define _CEGOXPORTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoXPorter.h
// -------------
// Cego import and export class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoXPorter
// 
// Description: Tableset export methods ( binary and xml ) 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDefs.h"
#include "CegoBufferPool.h"
#include "CegoDistManager.h"
#include "CegoAdminHandler.h"
#include "CegoPredicate.h"


class CegoXPorter {
    
 public:

    CegoXPorter(CegoDistManager *pGTM, CegoAdminHandler *pAH = 0);
    ~CegoXPorter();

    void xmlImportTableSet(const Chain& tableSet, bool isStructure, const Chain& impFile);
    unsigned long long xmlImportTable(const Chain& tableSet, const Chain& tableName, const Chain& impFile);
    void xmlExportTableSet(const Chain& tableSet, bool isStructure, const Chain& expFile);
    unsigned long long xmlExportTable(const Chain& tableSet, const Chain& tableName, const Chain& expFile);
    void binImportTableSet(const Chain& tableSet, bool isStructure, const Chain& impFile, bool doPlain);
    unsigned long long binImportTable(const Chain& tableSet, const Chain& tableName, const Chain& impFile, bool doPlain);
    void binExportTableSet(const Chain& tableSet, bool isStructure, const Chain& expFile, bool doPlain);
    unsigned long long binExportTable(const Chain& tableSet, const Chain& tableName, const Chain& expFile, bool doPlain);

 private:
    
    enum BinTag { TSTAG, TABTAG, IDXTAG, VIEWTAG, PROCTAG, KEYTAG, FLDTAG, ROWTAG, EOFTAG, SEPTAG, CNTTAG, CHECKTAG, TRIGGERTAG, ALIASTAG };

    void writeHeader(File *pOutFile, const Chain& tableSet);
    unsigned long long writeTableObject(File *pOutFile, int tabSetId, const Chain& tableName, const ListT<CegoField>& schema, bool doPlain);
    void writeIndexObject(File *pOutFile, int tabSetId, const Chain& idxName, const Chain& tableName, CegoObject::ObjectType type, const ListT<CegoField>& schema);
    void writeKeyObject(File *pOutFile, int tabSetId, const Chain& keyName, const Chain& tableName, const Chain& refTable, 
			const ListT<CegoField>& keySchema, const ListT<CegoField>& refSchema);
    void writeCheckObject(File *pOutFile, int tabSetId, const Chain& checkName, const Chain& tableName, 
			  CegoPredicate *pPredDesc);
    void writeTriggerObject(File *pOutFile, int tabSetId, const Chain& triggerName, const Chain& tableName,
			    bool isBefore, bool isOnInsert, bool isOnUpdate, bool isOnDelete, 
			    const Chain& triggerText);
    void writeAliasObject(File *pOutFile, int tabSetId, const Chain& aliasName, const Chain& tableName,
			  const ListT<CegoAttrAlias>& aliasList);
    void writeViewObject(File *pOutFile, int tabSetId, const Chain& viewName, const ListT<CegoField>& keySchema, const Chain& viewStmt);
    void writeProcObject(File *pOutFile, int tabSetId, const Chain& procName, const Chain& procText);
    void writeCounterObject(File *pOutFile, int tabSetId, const Chain& counterName, unsigned long long counterValue);
    unsigned long long writeTableData(File *pOutFile, int tabSetId, const Chain& tableName, const ListT<CegoField>& schema, bool doPlain);
    void writeRow(File *pOutFile, int tabSetId, const ListT<CegoField>& rowSchema);
    void readHeader(File *pInFile, Chain& tableSet);
    unsigned long long readTableObject(File *pInFile, const Chain& tableSet, bool doPlain);
    void readIndexObject(File *pInFile, const Chain& tableSet);
    void readKeyObject(File *pInFile, const Chain& tableSet);
    void readCheckObject(File *pInFile, const Chain& tableSet);
    void readTriggerObject(File *pInFile, const Chain& tableSet);
    void readAliasObject(File *pInFile, const Chain& tableSet);
    void readViewObject(File *pInFile, const Chain& tableSet);
    void readProcObject(File *pInFile, const Chain& tableSet);
    void readCounterObject(File *pInFile, const Chain& tableSet);
    void readRow(File *pInFile, int tabSetId, const Chain& tableName, const ListT<CegoField>& rowSchema);

    BinTag _tag;
    CegoDistManager *_pGTM;
    CegoDatabaseManager *_pDBMng;
    CegoAdminHandler *_pAH;
    CegoTableObject _oe;
    CegoDataPointer _sysEntry;
    char _inBuf[XP_MAXINBUF];
    char _colBuffer[XP_MAXCOLBUF];
    char _pdBuffer[XP_MAXPDBUF];
    
    unsigned long _modId;
};
#endif
