--
-- ### Delete with subselect
-- 
--

drop if exists table a_sysres;
create table a_sysres ( resid int, instid int);

drop if exists table a_sapinst;
create table a_sapinst (  instid int, instname string(10));

drop if exists table a_sysinst;
create table a_sysinst ( instid int, sysid int);

drop if exists table a_system;
create table a_system ( sysid int, sysname string(10));

drop if exists table a_mt;
create table a_mt ( mid int, sysid int);

drop if exists table a_mtlog;
create table a_mtlog ( mid int, a_log string(10));

insert into a_system values ( 1, 'SYSA');

insert into a_sysinst values ( 1, 1);
insert into a_sysinst values ( 2, 1);
insert into a_sysinst values ( 3, 1);

insert into a_sapinst values ( 1, 'SAP1');
insert into a_sapinst values ( 2, 'SAP2');
insert into a_sapinst values ( 3, 'SAP3');

insert into a_sysres values ( 1, 1 );

drop if exists procedure deleteSystem;
@
create procedure deleteSystem(sysid in int)
begin
   -- delete with nested subselect, since one var reference, should be NOT cached
   delete from a_sysres where instid in ( select instid from a_sysinst where sysid = :sysid );
   -- delete with nested static subselect, should be cached ( not really useful, just for cache testing )
   delete from a_sapinst where instid in ( select instid from a_sysinst where sysid = 1 );
   delete from a_sysinst where sysid = :sysid;
   delete from a_system where sysid = :sysid;
end;
@

start transaction;
call deleteSystem(1);
commit;
