#ifndef _CEGOJOINOBJECT_H_INCLUDED_
#define _CEGOJOINOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoJoinObject.h
// ----------------
// Cego join object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoJoinObject
// 
// Description: Cego join object container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoContentObject.h"
#include "CegoPredicate.h"

class CegoJoinObject : public CegoContentObject {

 public:

    enum JoinType { INNER, LEFTOUTER, RIGHTOUTER  };

    CegoJoinObject();
    CegoJoinObject(const CegoJoinObject& jo);
    CegoJoinObject( JoinType joinType, CegoContentObject *pLeftObject, CegoContentObject *pRightObject, CegoPredicate *pPred = 0);
    ~CegoJoinObject();
    
    int getEntrySize() const;
    void encode(char *buf) const;
    void decode(char *buf);
    void setSchema(const ListT<CegoField>& schema);
    JoinType getJoinType();
    CegoContentObject* getLeftObject();
    CegoContentObject* getRightObject();
    CegoPredicate* getPredDesc();
    void getPredList(ListT<CegoPredicate*>& predList);
    void setEmpty();
    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(int defTabSetId) const;
    CegoContentObject* clone(bool isAttrRef = false);    
    Chain getFormatted() const;

    ListT<Chain> getSubAliasList() const;
    
    CegoJoinObject& operator = ( const CegoJoinObject& jo);
    bool operator == ( const CegoJoinObject& jo);

 private:

    Chain fill(const Chain& s, int num) const;

    JoinType _joinType;
    CegoContentObject *_pLeftObject;
    CegoContentObject *_pRightObject;
    CegoPredicate *_pPred;
};
#endif
