#ifndef _CEGOPROCASSIGNSTMT_H_INCLUDED_
#define _CEGOPROCASSIGNSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcAssignStmt.h  
// --------------------
// Cego procedure assign statement implementation
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcAssignStmt
// 
// Description: Stored procedure assignment statement 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoProcStmt.h"
#include "CegoExpr.h"
#include "CegoProcBlock.h"

class CegoProcAssignStmt : public CegoProcStmt  {
    
public:
    
    enum AssignmentMode { EXPR2PARAM, EXPR2NULL };
    
    CegoProcAssignStmt(CegoExpr *pExpr,
		       CegoProcBlock *pBlock);
    CegoProcAssignStmt(const Chain& paramName,
		       CegoExpr *pExpr,
		       CegoProcBlock *pBlock);
    ~CegoProcAssignStmt();
    
    CegoException execute();
    void cleanUp();
    Chain toChain(int defTabSetId, const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    bool isStatic() const;
    
private:
    
    AssignmentMode _mode;
    Chain _paramName;
    CegoExpr *_pExpr;
    CegoProcBlock *_pBlock;
};
#endif
