#ifndef _CEGOPROCEDURE_H_INCLUDED_
#define _CEGOPROCEDURE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcedure.h  
// ---------------
// Cego procedure class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcedure
// 
// Description: Stored procedure container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcVar.h"
#include "CegoExpr.h"

class CegoDatabaseFormater;

class CegoProcedure  {
    
public:

    enum ProcType { PROCEDURE, FUNCTION };
    
    CegoProcedure();
    CegoProcedure(const Chain& procName, CegoProcBlock *pBlock);
    CegoProcedure(const Chain& procName, CegoProcBlock *pBlock, CegoDataType returnType, int returnTypeLen, int returnTypeDim);
    ~CegoProcedure();

    void setMasterBlock(CegoProcBlock *pBlock);
    CegoProcBlock* getMasterBlock() const;
    void getArgList(ListT<CegoProcVar>& argList);
    ListT<CegoProcVar>& getOutParamList();
    const Chain& getName() const;
    CegoProcBlock* getBlock();
    void execute(const ListT<CegoFieldValue>& fvl);
    void cleanUp();
    CegoFieldValue getRetVal() const;
    CegoDataType getReturnType() const;
    int getReturnTypeLen() const;
    int getReturnTypeDim() const;
    ProcType getProcType() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    Chain toChain(int defTabSetId) const;
    void enableProcCache(bool isEnabled);
    
    CegoProcedure& operator = (const CegoProcedure& p);
    bool operator == (const CegoProcedure& p) const;
    
private:

    class ProcCacheValue
    {
    public:
	ProcCacheValue(const ListT<CegoFieldValue>& fvl, const CegoFieldValue& retVal);
	ProcCacheValue(const ListT<CegoFieldValue>& fvl);
	ProcCacheValue();
	~ProcCacheValue();

	ProcCacheValue& operator = (const ProcCacheValue& pcv);
	bool operator == (const ProcCacheValue& pcv) const;

	CegoFieldValue& getRetVal();
	
    private:

	Chain _paramHash;
	CegoFieldValue _retVal;
    };

    bool getCacheValue(const ListT<CegoFieldValue>& fvl, CegoFieldValue& fv);
    void addCacheValue(const ListT<CegoFieldValue>& fvl, const CegoFieldValue& retVal);

    bool _cacheEnabled;
    
    SetT<ProcCacheValue> _cacheSet;
    
    CegoDataType _returnType;
    int _returnTypeLen;
    int _returnTypeDim;
    
    ProcType _procType;
    Chain _procName;
    CegoProcBlock* _pBlock;
    CegoProcBlock* _pMasterBlock;

    ListT<CegoProcVar> _outParamList;
};
#endif
