#ifndef _CEGOXMLDEF_H_INCLUDED_
#define _CEGOXMLDEF_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoXMLdef.h
// ------------
// Cego XML tag and attribute definition
//                
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: NA
// 
// Description: XML tag and attribute definitions
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "CegoDefs.h"

#define XML_VERSION_ATTR "version"
#define XML_VERSION_VALUE "1.0"
#define XML_CEGO "CEGO"

// session requests
#define XML_ADMINSESSION_REQUEST "ADMINSESSION"
#define XML_DBSESSION_REQUEST "DBSESSION"
#define XML_LOGSESSION_REQUEST "LOGSESSION"
#define XML_SESSION_CLOSE "CLOSE"

// admin session requests
#define XML_RETRIEVETABLESET_REQUEST "RETRIEVETABLESET"
#define XML_LOCKINFO_REQUEST "LOCKINFO"
#define XML_LOCKSTAT_REQUEST "LOCKSTAT"
#define XML_POOLINFO_REQUEST "POOLINFO"
#define XML_PARAMETERINFO_REQUEST "PARAMETERINFO"
#define XML_POOLENTRYLIST_REQUEST "POOLENTRYLIST"
#define XML_THREADINFO_REQUEST "THREADINFO"
#define XML_DBTHREADABORT_REQUEST "DBTHREADABORT"
#define XML_DBTHREADINFO_REQUEST "DBTHREADINFO"
#define XML_DBTHREADHIST_REQUEST "DBTHREADHIST"
#define XML_QUERYHISTLAST_REQUEST "QUERYHISTLAST"
#define XML_QUERYHISTCOST_REQUEST "QUERYHISTCOST"
#define XML_SETNUMQUERYLAST_REQUEST "SETNUMQUERYLAST"
#define XML_SETNUMQUERYCOST_REQUEST "SETNUMQUERYCOST"
#define XML_ADMTHREADINFO_REQUEST "ADMTHREADINFO"
#define XML_LOGTHREADINFO_REQUEST "LOGTHREADINFO"
#define XML_DBSESSIONINFO_REQUEST "DBSESSIONINFO"
#define XML_COPYINFO_REQUEST "COPYINFO"
#define XML_SHOWQUERYCACHE_REQUEST "SHOWQUERYCACHE"
#define XML_LISTQUERYCACHE_REQUEST "LISTQUERYCACHE"
#define XML_CLEANQUERYCACHE_REQUEST "CLEANQUERYCACHE"
#define XML_SETQUERYCACHEPARAM_REQUEST "SETQUERYCACHEPARAM"
#define XML_SETTABLECACHEPARAM_REQUEST "SETTABLECACHEPARAM"
#define XML_SHOWTABLECACHE_REQUEST "SHOWTABLECACHE"
#define XML_LISTTABLECACHE_REQUEST "LISTTABLECACHE"
#define XML_CLEANTABLECACHE_REQUEST "CLEANTABLECACHE"
#define XML_DEFINE_TABLESET_REQUEST "DEFINE_TABLESET"
#define XML_REMOVE_TABLESET_REQUEST "REMOVE_TABLESET"
#define XML_RESET_TABLESET_REQUEST "RESET_TABLESET"
#define XML_CREATE_TABLESET_REQUEST "CREATE_TABLESET"
#define XML_COPY_TABLESET_REQUEST "COPY_TABLESET"
#define XML_COPY_FILE_REQUEST "COPY_FILE"
#define XML_CREATE_FKEY_REQUEST "CREATE_FKEY"
#define XML_DROP_TABLESET_REQUEST "DROP_TABLESET"
#define XML_DROP_OBJECT_REQUEST "DROP_OBJECT"
#define XML_GET_NODELIST_REQUEST "GET_NODELIST"
#define XML_GET_DBINFO_REQUEST "GET_DBINFO"
#define XML_GET_TSINFO_REQUEST "GET_TSINFO"
#define XML_GET_DETAILED_TSINFO_REQUEST "GET_DETAILED_TSINFO"
#define XML_GET_ARCHLOG_INFO_REQUEST "GET_ARCHLOG_INFO"
#define XML_GET_OBJECT_INFO_REQUEST "GET_OBJECT_INFO"
#define XML_GET_TRANSACTION_INFO_REQUEST "GET_TRANSACTION_INFO"
#define XML_GET_BUSTAT_REQUEST "GET_BUSTAT"
#define XML_RESET_BUSTAT_REQUEST "GET_BUSTAT"
#define XML_GET_DBSPEC_REQUEST "GET_DBSPEC"
#define XML_INIT_LOGS_REQUEST "INIT_LOGS"
#define XML_PROP_TSINFO_REQUEST "PROP_TSINFO"
#define XML_SET_TABLESETNODE_REQUEST "SET_TABLESETNODEINFO"
#define XML_SET_LSN_REQUEST "SET_LSN"
#define XML_SET_RUNSTATE_REQUEST "SET_RUNSTATE"
#define XML_SET_SYNCSTATE_REQUEST "SET_SYNCSTATE"
#define XML_START_TABLESET_REQUEST "START_TABLESET"
#define XML_START_RECOVER_REQUEST "START_RECOVER"
#define XML_STOP_TABLESET_REQUEST "STOP_TABLESET"
#define XML_STOP_RECOVER_REQUEST "STOP_RECOVER"
#define XML_RESTORE_REQUEST "RESTORE"
#define XML_RECOVER_REQUEST "RECOVER"
#define XML_SECSWITCH_REQUEST "SECSWITCH"
#define XML_SYNC_TABLESET_REQUEST "SYNC_TABLESET"
#define XML_EXPORT_TABLESET_REQUEST "EXPORT_TABLESET"
#define XML_IMPORT_TABLESET_REQUEST "IMPORT_TABLESET"
#define XML_EXPORT_TABLE_REQUEST "EXPORT_TABLE"
#define XML_IMPORT_TABLE_REQUEST "IMPORT_TABLE"
#define XML_ADD_DATAFILE_REQUEST "ADD_DATAFILE"
#define XML_SHOW_USER_REQUEST "SHOW_USER"
#define XML_ADD_USER_REQUEST "ADD_USER"
#define XML_REMOVE_USER_REQUEST "REMOVE_USER"
#define XML_CHANGE_PWD_REQUEST "CHANGE_PWD"
#define XML_ASSIGN_ROLE_REQUEST "ASSIGN_ROLE"
#define XML_REMOVE_ROLE_REQUEST "REMOVE_ROLE"
#define XML_LIST_ROLE_REQUEST "LIST_ROLE"
#define XML_SHOW_ROLE_REQUEST "SHOW_ROLE"
#define XML_CREATE_ROLE_REQUEST "CREATE_ROLE"
#define XML_DROP_ROLE_REQUEST "DROP_ROLE"
#define XML_SET_PERM_REQUEST "SET_PERM"
#define XML_REMOVE_PERM_REQUEST "REMOVE_PERM"
#define XML_USER_TRACE_REQUEST "USER_TRACE"
#define XML_ADD_ARCHLOG_REQUEST "ADD_ARCHLOG"
#define XML_REMOVE_ARCHLOG_REQUEST "REMOVE_ARCHLOG"
#define XML_BEGIN_BACKUP_REQUEST "BEGIN_BACKUP"
#define XML_EXECUTE_BACKUP_REQUEST "EXECUTE_BACKUP"
#define XML_END_BACKUP_REQUEST "END_BACKUP"
#define XML_LIST_BACKUP_REQUEST "LIST_BACKUP"
#define XML_VERIFY_TABLESET_REQUEST "VERIFY_TABLESET"
#define XML_CORRECT_TABLESET_REQUEST "CORRECT_TABLESET"
#define XML_DUMP_OBJECT_REQUEST "DUMP_OBJECT"
#define XML_SET_LOGMNG_REQUEST "SET_LOGMNG"
#define XML_SET_BACKUPMNG_REQUEST "SET_BACKUPMNG"
#define XML_SHOW_LOGMNG_REQUEST "SHOW_LOGMNG"
#define XML_SHOW_BACKUPMNG_REQUEST "SHOW_BACKUPMNG"
#define XML_SET_CHECKPOINT_REQUEST "SET_CHECKPOINT"
#define XML_SET_TSINITFILE_REQUEST "SET_TSINITFILE"
#define XML_SET_TSROOTPATH_REQUEST "SET_TSROOTPATH"
#define XML_SET_TSSYSSIZE_REQUEST "SET_TSSYSSIZE"
#define XML_SET_TSTMPSIZE_REQUEST "SET_TSTMPSIZE"
#define XML_SET_TSAPPSIZE_REQUEST "SET_TSAPPSIZE"
#define XML_SET_TSLOGNUM_REQUEST "SET_TSLOGNUM"
#define XML_SET_TSLOGSIZE_REQUEST "SET_TSLOGSIZE"
#define XML_SET_TSSORTAREASIZE_REQUEST "SET_TSSORTAREASIZE"
#define XML_SET_TSLOGUSER_REQUEST "SET_TSLOGUSER"
#define XML_ENABLE_TABLECACHE_REQUEST "MED_ENABLE_TABLECACHE"
#define XML_DISABLE_TABLECACHE_REQUEST "MED_DISABLE_TABLECACHE"
#define XML_ENABLE_QUERYCACHE_REQUEST "MED_ENABLE_QUERYCACHE"
#define XML_DISABLE_QUERYCACHE_REQUEST "MED_DISABLE_QUERYCACHE"

// mediator requests
#define XML_MED_NOTIFY_REQUEST "MED_NOTIFY"
#define XML_MED_DEFINE_TABLESET_REQUEST "MED_DEFINE_TABLESET"
#define XML_MED_REMOVE_TABLESET_REQUEST "MED_REMOVE_TABLESET"
#define XML_MED_RESET_TABLESET_REQUEST "MED_RESET_TABLESET"
#define XML_MED_CREATE_TABLESET_REQUEST "MED_CREATE_TABLESET"
#define XML_MED_CORRECT_TABLESET_REQUEST "MED_CORRECT_TABLESET"
#define XML_MED_DROP_TABLESET_REQUEST "MED_DROP_TABLESET"
#define XML_MED_START_TABLESET_REQUEST "MED_START_TABLESET"
#define XML_MED_STOP_TABLESET_REQUEST "MED_STOP_TABLESET"
#define XML_MED_COPY_TABLESET_REQUEST "MED_COPY_TABLESET"
#define XML_MED_SWITCH_TABLESET_REQUEST "MED_SWITCH_TABLESET"
#define XML_MED_ADD_ARCHLOG_REQUEST "MED_ADD_ARCHLOG"
#define XML_MED_REMOVE_ARCHLOG_REQUEST "MED_REMOVE_ARCHLOG"
#define XML_MED_ADD_DATAFILE_REQUEST "MED_ADD_DATAFILE"
#define XML_MED_GET_TABLESETLIST_REQUEST "MED_GET_TABLESETLIST"
#define XML_MED_GET_DETAILEDTABLESETINFO_REQUEST "MED_GET_DETAILEDTABLESETINFO"
#define XML_MED_GET_OBJECTINFO_REQUEST "MED_GET_OBJECTINFO"
#define XML_MED_GET_ARCHLOGINFO_REQUEST "MED_GET_ARCHLOGINFO"
#define XML_MED_GET_TRANSACTIONINFO_REQUEST "MED_GET_TRANSACTIONINFO"
#define XML_MED_GET_BUSTAT_REQUEST "MED_GET_BUSTAT"
#define XML_MED_RESET_BUSTAT_REQUEST "MED_RESET_BUSTAT"
#define XML_MED_BEGIN_BACKUP_REQUEST "MED_BEGIN_BACKUP"
#define XML_MED_EXECUTE_BACKUP_REQUEST "MED_EXECUTE_BACKUP"
#define XML_MED_END_BACKUP_REQUEST "MED_END_BACKUP"
#define XML_MED_LIST_BACKUP_REQUEST "MED_LIST_BACKUP"
#define XML_MED_RESTORE_REQUEST "MED_RESTORE"
#define XML_MED_RECOVER_REQUEST "MED_RECOVER"
#define XML_MED_SECSWITCH_REQUEST "MED_SECSWITCH"
#define XML_MED_SECRELOCATE_REQUEST "MED_SECRELOCATE"
#define XML_MED_CHECK_TABLESET_REQUEST "MED_CHECK_TABLESET"
#define XML_MED_VERIFY_TABLESET_REQUEST "MED_VERIFY_TABLESET"
#define XML_MED_ENABLE_ARCHLOG_REQUEST "MED_ENABLE_ARCHLOG"
#define XML_MED_DISABLE_ARCHLOG_REQUEST "MED_DISABLE_ARCHLOG"
#define XML_MED_ENABLE_AUTOCORRECT_REQUEST "MED_ENABLE_AUTOCORRECT"
#define XML_MED_DISABLE_AUTOCORRECT_REQUEST "MED_DISABLE_AUTOCORRECT"
#define XML_MED_ENABLE_APPENDMODE_REQUEST "MED_ENABLE_APPENDMODE"
#define XML_MED_DISABLE_APPENDMODE_REQUEST "MED_DISABLE_APPENDMODE"
#define XML_SEC_MEDSWITCH_REQUEST "SEC_MEDSWITCH"
#define XML_SEC_MEDRELOCATE_REQUEST "SEC_MEDRELOCATE"

// db session requests
#define XML_ALTERTABLE_REQUEST "ALTERTABLE"
#define XML_CREATETABLE_REQUEST "CREATETABLE"
#define XML_CREATEINDEX_REQUEST "CREATEINDEX"
#define XML_CREATEVIEW_REQUEST "CREATEVIEW"
#define XML_CREATEPROCEDURE_REQUEST "CREATEPROCEDURE"
#define XML_CREATETRIGGER_REQUEST "CREATETRIGGER"
#define XML_DELETE_REQUEST "DELETE"
#define XML_GETTABLE_REQUEST "GETTABLE"
#define XML_GETOBJLIST_REQUEST "GETOBJLIST"
#define XML_GETOBJLISTBYTABLE_REQUEST "GETOBJLISTBYTABLE"
#define XML_INSERT_REQUEST "INSERT"
#define XML_UPDATE_REQUEST "UPDATE"
#define XML_DELETE_REQUEST "DELETE"
#define XML_OBJECTINFO_REQUEST "OBJECTINFO"
#define XML_QUERY_REQUEST "QUERY"
#define XML_QUERYABORT_REQUEST "QUERYABORT"
#define XML_DBPRODINFO_REQUEST "DBPRODINFO"
#define XML_OBJRENAME_REQUEST "OBJRENAME"
#define XML_SYNC_REQUEST "SYNC"
#define XML_GETPAGECOUNT_REQUEST "GETPAGECOUNT"
#define XML_REORG_REQUEST "REORG"
#define XML_PUTBLOB_REQUEST "PUTBLOB"
#define XML_GETBLOB_REQUEST "GETBLOB"
#define XML_DELBLOB_REQUEST "DELBLOB"
#define XML_PUTCLOB_REQUEST "PUTCLOB"
#define XML_GETCLOB_REQUEST "GETCLOB"
#define XML_DELCLOB_REQUEST "DELCLOB"
#define XML_STARTTRANSACTION_REQUEST "STARTTRANSACTION"
#define XML_COMMITTRANSACTION_REQUEST "COMMITTRANSACTION"
#define XML_ROLLBACKTRANSACTION_REQUEST "ROLLBACKTRANSACTION"
#define XML_GETTID_REQUEST "GETTID"
#define XML_CREATECHECK_REQUEST "CREATECHECK"

// response types
#define XML_CEGO_DB_CONFIG_DOC "CEGO_DB_CONFIG"
#define XML_ERROR_DOC "ERROR"
#define XML_OK_DOC "OK"
#define XML_SACK_DOC "SACK"
#define XML_DATA_DOC "DATA"
#define XML_INFO_DOC "INFO"
#define XML_EXPORT_DOC "CEGO_EXPORT"
#define XML_IMPORT_DOC "CEGO_IMPORT"
#define XML_TSTICKET_DOC "TSTICKET"

// xml tags 
#define XML_ALTER_ELEMENT "ALTER"
#define XML_AGGREGATION_ELEMENT "AGGREGATION"
#define XML_ALIAS_ELEMENT "ALIAS"
#define XML_ARCHINFO_ELEMENT "ARCHINFO"
#define XML_ARCHIVELOG_ELEMENT "ARCHIVELOG"
#define XML_BACKUPMNGINFO_ELEMENT "BACKUPMNGINFO"
#define XML_ATTRCHECK_ELEMENT "ATTRCHECK"
#define XML_ATTRDESC_ELEMENT "ATTRDESC"
#define XML_BACKUP_ELEMENT "BACKUP"
#define XML_BACKUPLIST_ELEMENT "BACKUPLIST"
#define XML_BLOB_ELEMENT "BLOB"
#define XML_BUSINFO_ELEMENT "BUSINFO"
#define XML_BUENTRY_ELEMENT "BUENTRY"
#define XML_CACHE_ELEMENT "CACHE"
#define XML_CACHEINFO_ELEMENT "CACHEINFO"
#define XML_CASE_ELEMENT "CASE"
#define XML_CASECLAUSE_ELEMENT "CASECLAUSE"
#define XML_CHECK_ELEMENT "CHECK"
#define XML_CODESC_ELEMENT "CODESC"
#define XML_COL_ELEMENT "COL"
#define XML_COLIST_ELEMENT "COLIST"
#define XML_COND_ELEMENT "COND"
#define XML_COPY_ELEMENT "COPY"
#define XML_COPYINFO_ELEMENT "COPYINFO"
#define XML_COUNTER_ELEMENT "COUNTER"
#define XML_CORRECTION_ELEMENT "CORRECTION"
#define XML_DATA_ELEMENT "DATA"
#define XML_DATABASE_ELEMENT "DATABASE"
#define XML_DATAFILE_ELEMENT "DATAFILE"
#define XML_DATETIMEFORMAT_ELEMENT "DATETIMEFORMAT"
#define XML_DBINFO_ELEMENT "DBINFO"
#define XML_DBSESSION_ELEMENT "DBSESSION"
#define XML_DBSESSIONINFO_ELEMENT "DBSESSIONINFO"
#define XML_EXPR_ELEMENT "EXPR"
#define XML_FACTOR_ELEMENT "FACTOR"
#define XML_FIELD_ELEMENT "FIELD"
#define XML_FILEINFO_ELEMENT "FILEINFO"
#define XML_FRAME_ELEMENT "FRAME"
#define XML_FKEY_ELEMENT "FKEY"
#define XML_FUNCTION_ELEMENT "FUNCTION"
#define XML_GDID_ELEMENT "GDID"
#define XML_GROUPING_ELEMENT "GROUPING"
#define XML_HAVING_ELEMENT "HAVING"
#define XML_HOST_ELEMENT "HOST"
#define XML_INDEX_ELEMENT "INDEX"
#define XML_JOIN_ELEMENT "JOIN"
#define XML_KEY_ELEMENT "KEY"
#define XML_KEYSCHEMA_ELEMENT "KEYSCHEMA"
#define XML_LOCKINFO_ELEMENT "LOCKINFO"
#define XML_LOCKSTAT_ELEMENT "LOCKSTAT"
#define XML_LOCKENTRY_ELEMENT "LOCKENTRY"
#define XML_LOGFILE_ELEMENT "LOGFILE"
#define XML_LOGMNGINFO_ELEMENT "LOGMNGINFO"
#define XML_MODULE_ELEMENT "MODULE"
#define XML_NODE_ELEMENT "NODE"
#define XML_NODEINFO_ELEMENT "NODEINFO"
#define XML_NOROWS_ELEMENT "NOROWS"
#define XML_OBJ_ELEMENT "OBJ"
#define XML_OBJLIST_ELEMENT "OBJLIST"
#define XML_OUTPARAM_ELEMENT "OUTPARAM"
#define XML_ORDERING_ELEMENT "ORDERING"
#define XML_PARAMETERLIST_ELEMENT "PARAMETERLIST"
#define XML_PARAMETERINFO_ELEMENT "PARAMETERINFO"
#define XML_PERM_ELEMENT "PERM"
#define XML_PERMINFO_ELEMENT "PERMINFO"
#define XML_PLAN_ELEMENT "PLAN"
#define XML_POOLINFO_ELEMENT "POOLINFO"
#define XML_POOLENTRYLIST_ELEMENT "POOLENTRYLIST"
#define XML_POOLENTRY_ELEMENT "POOLENTRY"
#define XML_PRED_ELEMENT "PRED"
#define XML_QUERY_ELEMENT "QUERY"
#define XML_PROCEDURE_ELEMENT "PROCEDURE"
#define XML_REFSCHEMA_ELEMENT "REFSCHEMA"
#define XML_REF_ELEMENT "REF"
#define XML_ROLE_ELEMENT "ROLE"
#define XML_ROLELIST_ELEMENT "ROLELIST"
#define XML_ROW_ELEMENT "ROW"
#define XML_SCHEMA_ELEMENT "SCHEMA"
#define XML_SELECT_ELEMENT "SELECT"
#define XML_SELECTION_ELEMENT "SELECTION"
#define XML_TABLE_ELEMENT "TABLE"
#define XML_TABLEDESC_ELEMENT "TABLEDESC"
#define XML_TABLELIST_ELEMENT "TABLELIST"
#define XML_TABLESET_ELEMENT "TABLESET"
#define XML_TABLESETLIST_ELEMENT "TABLESETLIST"
#define XML_TABLESETCHECK_ELEMENT "TABLESETCHECK"
#define XML_TAINFO_ELEMENT "TAINFO"
#define XML_TAENTRY_ELEMENT "TAENTRY"
#define XML_TERM_ELEMENT "TERM"
#define XML_THREAD_ELEMENT "THREAD"
#define XML_THREADINFO_ELEMENT "THREADINFO"
#define XML_QUERYHIST_ELEMENT "QUERYHIST"
#define XML_TRIGGER_ELEMENT "TRIGGER"
#define XML_USERINFO_ELEMENT "USERINFO"
#define XML_USER_ELEMENT "USER"
#define XML_VERIFICATION_ELEMENT "VERIFICATION"
#define XML_VIEW_ELEMENT "VIEW"

// xml attributes
#define XML_ACTIVEDBTHREAD_ATTR "ACTDBTHREAD"
#define XML_ACTIVEADMTHREAD_ATTR "ACTADMTHREAD"
#define XML_ACTIVELOGTHREAD_ATTR "ACTLOGTHREAD"
#define XML_ADMINPORT_ATTR "ADMINPORT"
#define XML_AFFECTED_ATTR "AFFCOUNT"
#define XML_AGG_ATTR "AGG"
#define XML_APPSIZE_ATTR "APPSIZE"
#define XML_BACKUPMNGPROG_ATTR "BACKUPMNGPROG"
#define XML_BRANCHID_ATTR "BRANCHID"
#define XML_APPENDMODE_ATTR "APPENDMODE"
#define XML_ARCHMODE_ATTR "ARCHMODE"
#define XML_ARCHID_ATTR "ARCHID"
#define XML_ARCHPATH_ATTR "ARCHPATH"
#define XML_ATTRNAME_ATTR "ATTRNAME"
#define XML_AUTOCORRECT_ATTR "AUTOCORRECT"
#define XML_AVGFIXTRY_ATTR "AVGFIXTRY"
#define XML_BPHITRATE_ATTR "BPHITRATE"
#define XML_SPREADRATE_ATTR "SPREADRATE"
#define XML_BACKUPID_ATTR "BACKUPID"
#define XML_BACKUPTS_ATTR "BACKUPTS"
#define XML_BUINFO_ATTR "BUINFO"
#define XML_BUMSG_ATTR "BUMSG"
#define XML_CSMODE_ATTR "CSMODE"
#define XML_CHECKATTR_ATTR "CHECKATTR"
#define XML_CHECKPOINT_ATTR "CHECKPOINT"
#define XML_CID_ATTR "CID"
#define XML_CLEANUP_ATTR "CLEANUP"
#define XML_CMD_ATTR "CMD"
#define XML_COLNAME_ATTR "COLNAME"
#define XML_COLALIAS_ATTR "COLALIAS"
#define XML_COLVAL_ATTR "COLVAL"
#define XML_COLTYPE_ATTR "COLTYPE"
#define XML_COLTYPEID_ATTR "COLTYPEID"
#define XML_COLSIZE_ATTR "COLSIZE"
#define XML_COLDIM_ATTR "COLDIM"
#define XML_COLNULLABLE_ATTR "COLNULLABLE"
#define XML_COLDEFVALUE_ATTR "COLDEFVALUE"
#define XML_COMP_ATTR "COMP"
#define XML_COND_ATTR "COND"
#define XML_COST_ATTR "COST"
#define XML_CPDUMP_ATTR "CPDUMP"
#define XML_CURFIXCOUNT_ATTR "CURFIXCOUNT"
#define XML_CURRENCYSYMBOL_ATTR "CURRENCYSYMBOL"
#define XML_DATAPORT_ATTR "DATAPORT"
#define XML_DATALEN_ATTR "DATALEN"
#define XML_DATAID_ATTR "DATAID"
#define XML_DATETIMEFORMAT_ATTR "DATETIMEFORMAT"
#define XML_DECIMALPOINT_ATTR "DECIMALPOINT"
#define XML_DBNAME_ATTR "DBNAME"
#define XML_DBPRODNAME_ATTR "DBPRODNAME"
#define XML_DBPRODVERSION_ATTR "DBPRODVERSION"
#define XML_DUPLICATENULL_ATTR "DUPLICATENULL"
#define XML_EXPR_ATTR "EXPR"
#define XML_ESCCMD_ATTR "ESCCMD"
#define XML_FACTOR_ATTR "FACTOR"
#define XML_FILEID_ATTR "FILEID"
#define XML_FILESIZE_ATTR "FILESIZE"
#define XML_FILENAME_ATTR "FILENAME"
#define XML_FILELOCKTIMEOUT_ATTR "FILELOCKTIMEOUT"
#define XML_FILTER_ATTR "FILTER"
#define XML_FIXSTAT_ATTR "FIXSTAT"
#define XML_FORCELOAD_ATTR "FORCELOAD"
#define XML_FORMAT_ATTR "FORMAT"
#define XML_FUNCTYPE_ATTR "FUNCTYPE"
#define XML_FKEY_ATTR "FKEY"
#define XML_GROUPNAME_ATTR "GROUPNAME"
#define XML_HOSTNAME_ATTR "HOSTNAME"
#define XML_HOSTROLE_ATTR "HOSTROLE"
#define XML_ID_ATTR "ID"
#define XML_INDEXNAME_ATTR "INDEXNAME"
#define XML_INDEXTYPE_ATTR "INDEXTYPE"
#define XML_ISDIRTY_ATTR "ISDIRTY"
#define XML_ISSTRUCT_ATTR "ISSTRUCT"
#define XML_ISUSED_ATTR "ISUSED"
#define XML_ISBEFORE_ATTR "ISBEFORE"
#define XML_ISONINSERT_ATTR "ISONINSERT"
#define XML_ISONUPDATE_ATTR "ISONUPDATE"
#define XML_ISONDELETE_ATTR "ISONDELETE"
#define XML_JAVATYPE_ATTR "JAVATYPE"
#define XML_JOINSTRAT_ATTR "JOINSTRAT"
#define XML_LASTACTION_ATTR "LASTACTION"
#define XML_LASTPAGE_ATTR "LASTPAGE"
#define XML_LOCKID_ATTR "LOCKID"
#define XML_LOCKCAT_ATTR "LOCKCAT"
#define XML_LOCKCOUNT_ATTR "LOCKCOUNT"
#define XML_PARAMNAME_ATTR "PARAMNAME"
#define XML_PARAMVALUE_ATTR "PARAMVALUE"
#define XML_RDLOCKHIT_ATTR "RDLOCKHIT"
#define XML_RDLOCKDELAY_ATTR "RDLOCKDELAY"
#define XML_WRLOCKHIT_ATTR "WRLOCKHIT"
#define XML_WRLOCKDELAY_ATTR "WRLOCKDELAY"
#define XML_KEEPTICKET_ATTR "KEEPTICKET"
#define XML_LEVEL_ATTR "LEVEL"
#define XML_LOGPORT_ATTR "LOGPORT"
#define XML_LOGFILENAME_ATTR "LOGFILENAME"
#define XML_LOGFILESIZE_ATTR "LOGFILESIZE"
#define XML_LOGFILENUM_ATTR "LOGFILENUM"
#define XML_LOGMNGPROG_ATTR "LOGMNGPROG"
#define XML_LOGMNGTIMEOUT_ATTR "LOGMNGTIMEOUT"
#define XML_LOGUSER_ATTR "LOGUSER"
#define XML_LSN_ATTR "LSN"
#define XML_WRITTENLSN_ATTR "WRITTENLSN"
#define XML_NUMARCHIVED_ATTR "NUMARCHIVED"
#define XML_NUMLOCKTRIES_ATTR "NUMLOCKTRIES"
#define XML_SORTAREASIZE_ATTR "SORTAREASIZE"
#define XML_MAXFIXCOUNT_ATTR "MAXFIXCOUNT"
#define XML_TABLECACHEFILTER_ATTR "TABLECACHEFILTER"
#define XML_TABLECACHEMAXSIZE_ATTR "TABLECACHEMAXSIZE"
#define XML_TABLECACHEMAXENTRY_ATTR "TABLECACHEMAXENTRY"
#define XML_TABLECACHEHASHRANGE_ATTR "TABLECACHEHASHRANGE"
#define XML_TABLECACHEUSEDSIZE_ATTR "TABLECACHEUSEDSIZE"
#define XML_QUERY_ATTR "QUERY"
#define XML_QUERYCACHEMAXENTRY_ATTR "QUERYCACHEMAXENTRY"
#define XML_QUERYCACHEMAXSIZE_ATTR "QUERYCACHEMAXSIZE"
#define XML_QUERYCACHETHRESHOLD_ATTR "QUERYCACHETHRESHOLD"
#define XML_QUERYCACHEHASHRANGE_ATTR "QUERYCACHEHASHRANGE"
#define XML_QUERYCACHEUSEDSIZE_ATTR "QUERYCACHEUSEDSIZE"
#define XML_QUERYCACHEUSEDNUM_ATTR "QUERYCACHEUSEDNUM"
#define XML_QUERYCACHENUMFAIL_ATTR "QUERYCACHENUMFAIL"
#define XML_MVAL_ATTR "MVAL"
#define XML_MAXSENDLEN_ATTR "MAXSENDLEN"
#define XML_MAXTSID_ATTR "MAXTSID"
#define XML_MEDIATOR_ATTR "MEDIATOR"
#define XML_MODE_ATTR "MODE"
#define XML_MSG_ATTR "MSG"
#define XML_NAME_ATTR "NAME"
#define XML_NEWOBJNAME_ATTR "NEWOBJNAME"
#define XML_NUMENTRY_ATTR "NUMQUERY"
#define XML_NUMFILE_ATTR "NUMFILE"
#define XML_NUMDBTHREAD_ATTR "NUMDBTHREAD"
#define XML_NUMADMTHREAD_ATTR "NUMADMTHREAD"
#define XML_NUMLOCK_ATTR "NUMLOCK"
#define XML_NUMLOGTHREAD_ATTR "NUMLOGTHREAD"
#define XML_NUMTOTAL_ATTR "NUMTOTAL"
#define XML_NUMUSED_ATTR "NUMUSED"
#define XML_NUMFREE_ATTR "NUMFREE"
#define XML_NUMDIRTY_ATTR "NUMDIRTY"
#define XML_NUMFIXES_ATTR "NUMFIXES"
#define XML_NUMPERSISTENT_ATTR "NUMPERSISTENT"
#define XML_NUMNOSYNC_ATTR "NUMNOSYNC"
#define XML_NUMDISKREAD_ATTR "NUMDISKREAD"
#define XML_NUMDISKWRITE_ATTR "NUMDISKWRITE"
#define XML_NUMREQUEST_ATTR "NUMREQUEST"
#define XML_NUMQUERYREQUEST_ATTR "NUMQUERYREQUEST"
#define XML_NUMQUERY_ATTR "NUMQUERY"
#define XML_NUMQUERYLAST_ATTR "NUMQUERYLAST"
#define XML_NUMQUERYCOST_ATTR "NUMQUERYCOST"
#define XML_THREADLOAD_ATTR "THREADLOAD"
#define XML_THRIDX_ATTR "THRIDX"
#define XML_ALLOCATEDSORT_ATTR "ALLOCATEDSORT"
#define XML_RBO_ATTR "RBO"
#define XML_NUMOP_ATTR "NUMOP"
#define XML_PAGELOCKTIMEOUT_ATTR "PAGELOCKTIMEOUT"
#define XML_PERM_ATTR "PERM"
#define XML_PERMID_ATTR "PERMID"
#define XML_POOLLOCKTIMEOUT_ATTR "POOLLOCKTIMEOUT"
#define XML_PROCCACHE_ATTR "PROCCACHE"
#define XML_READDELAY_ATTR "READDELAY"
#define XML_RECLOCKTIMEOUT_ATTR "RECLOCKTIMEOUT"
#define XML_ROLE_ATTR "ROLE"
#define XML_WRITEDELAY_ATTR "WRITEDELAY"
#define XML_STATSTART_ATTR "STATSTART"
#define XML_NUMROWS_ATTR "NUMROWS"
#define XML_NUMHITS_ATTR "NUMHITS"
#define XML_NUMRECSEMA_ATTR "NUMRECSEMA"
#define XML_NUMRBRECSEMA_ATTR "NUMRBRECSEMA"
#define XML_NUMSYSRECSEMA_ATTR "NUMSYSRECSEMA"
#define XML_NUMSYSPAGESEMA_ATTR "NUMSYSPAGESEMA"
#define XML_NUMDATAPAGESEMA_ATTR "NUMDATAPAGESEMA"
#define XML_NUMIDXPAGESEMA_ATTR "NUMIDXPAGESEMA"
#define XML_NUMRBPAGESEMA_ATTR "NUMRBPAGESEMA"
#define XML_NUMDATAFILESEMA_ATTR "NUMDATAFILESEMA"
#define XML_NUMBUFFERPOOLSEMA_ATTR "NUMBUFFERPOOLSEMA"
#define XML_NUMUSAGE_ATTR "NUMUSAGE"
#define XML_MAXFIXTRIES_ATTR "MAXFIXTRIES"
#define XML_MAXPAGEDELETE_ATTR "MAXPAGEDELETE"
#define XML_MAXPAGEDELETE_ATTR "MAXPAGEDELETE"
#define XML_OBJNAME_ATTR "OBJNAME"
#define XML_OBJTYPE_ATTR "OBJTYPE"
#define XML_OCCSTATE_ATTR "OCCSTATE"
#define XML_OFFSET_ATTR "OFFSET"
#define XML_PATTERN_ATTR "PATTERN"
#define XML_PVAL_ATTR "PVAL"
#define XML_PAGEID_ATTR "PAGEID"
#define XML_PAGEOFFSET_ATTR "PAGEOFFSET"
#define XML_PAGESIZE_ATTR "PAGESIZE"
#define XML_PIDFILE_ATTR "PIDFILE"
#define XML_PIT_ATTR "PIT"
#define XML_POS_ATTR "POS"
#define XML_PRIMARY_ATTR "PRIMARY"
#define XML_PRED_ATTR "PRED"
#define XML_PROCNAME_ATTR "PROCNAME"
#define XML_PROCTEXT_ATTR "PROCTEXT"
#define XML_PROTOCOL_ATTR "PROTOCOL"
#define XML_TRIGGERNAME_ATTR "TRIGGERNAME"
#define XML_TRIGGERTEXT_ATTR "TRIGGERTEXT"
#define XML_QESCMODE_ATTR "QESCMODE"
#define XML_QUERYCACHE_ATTR "QUERYCACHE"
#define XML_QUEUEDELAY_ATTR "QUEUEDELAY"
#define XML_REFTABLENAME_ATTR "REFTABLENAME"
#define XML_ROLE_ATTR "ROLE"
#define XML_ROUNDMODE_ATTR "ROUNDMODE"
#define XML_RUNSTATE_ATTR "RUNSTATE"
#define XML_SCANDATETIMEFORMAT_ATTR "SCANDATETIMEFORMAT"
#define XML_SEGMENT_ATTR "SEGMENT"
#define XML_SECONDARY_ATTR "SECONDARY"
#define XML_SELECTTIMEOUT_ATTR "SELECTTIMEOUT"
#define XML_STATUS_ATTR "STATUS"
#define XML_SYNCSTATE_ATTR "SYNCSTATE"
#define XML_SYSSIZE_ATTR "SYSSIZE"
#define XML_SYSPAGEOFFSET_ATTR "SYSPAGEOFFSET"
#define XML_SIZE_ATTR "SIZE"
#define XML_SYSFILE_ATTR "SYSFILE"
#define XML_SYSFID_ATTR "SYSFID"
#define XML_SYSNAME_ATTR "SYSNAME"
#define XML_SYSTOTAL_ATTR "SYSTOTAL"
#define XML_SYSUSED_ATTR "SYSUSED"
#define XML_SVAL_ATTR "SVAL"
#define XML_TABLENAME_ATTR "TABLENAME"
#define XML_TABLEALIAS_ATTR "TABLEALIAS"
#define XML_TABLETYPE_ATTR "TABLETYPE"
#define XML_TARGETHOST_ATTR "TARGETHOST"
#define XML_TABLESET_ATTR "TABLESET"
#define XML_TABLECACHE_ATTR "TABLECACHE"
#define XML_TEMPPAGEOFFSET_ATTR "TEMPPAGEOFFSET"
#define XML_TERM_ATTR "TERM"
#define XML_TID_ATTR "TID"
#define XML_TIMESTAMP_ATTR "TIMESTAMP"
#define XML_TIMEOUT_ATTR "TIMEOUT"
#define XML_TRACE_ATTR "TRACE"
#define XML_TSID_ATTR "TSID"
#define XML_TSROOT_ATTR "TSROOT"
#define XML_TSTICKET_ATTR "TSTICKET"
#define XML_TSINITFILE_ATTR "TSINITFILE"
#define XML_TTL_ATTR "TTL"
#define XML_THID_ATTR "THID"
#define XML_TMPFID_ATTR "TMPFID"
#define XML_TMPSIZE_ATTR "TMPSIZE"
#define XML_TMPNAME_ATTR "TMPNAME"
#define XML_TEMPFILE_ATTR "TEMPFILE"
#define XML_TEMPTOTAL_ATTR "TEMPTOTAL"
#define XML_TEMPUSED_ATTR "TEMPUSED"
#define XML_TYPE_ATTR "TYPE"
#define XML_USAGE_ATTR "USAGE"
#define XML_PASSWD_ATTR "PASSWD"
#define XML_UPTIME_ATTR "UPTIME"
#define XML_USER_ATTR "USER"
#define XML_VALUE_ATTR "VALUE"
#define XML_VIEWSTMT_ATTR "VIEWSTMT"
#define XML_VIEWNAME_ATTR "VIEWNAME"
#define XML_VIEWTEXT_ATTR "VIEWTEXT"
#define XML_PAGECOUNT_ATTR "PAGECOUNT"
#define XML_SYSUSAGE_ATTR "SYSUSAGE"
#define XML_TEMPUSAGE_ATTR "TEMPUSAGE"
#define XML_APPUSAGE_ATTR "APPUSAGE"
#define XML_NOINIT_ATTR "NOINIT"

// xml values
#define XML_BIGINT_VALUE "bigint"
#define XML_FLOAT_VALUE "float"
#define XML_DOUBLE_VALUE "double"
#define XML_SMALLINT_VALUE "smallint"
#define XML_TINYINT_VALUE "tiny"
#define XML_DECIMAL_VALUE "decimal"
#define XML_STRING_VALUE "string"
#define XML_DATETIME_VALUE "datetime"
#define XML_BOOL_VALUE "bool"
#define XML_INT_VALUE "int"
#define XML_LONG_VALUE "long"
#define XML_BLOB_VALUE "blob"
#define XML_CLOB_VALUE "clob"
#define XML_NULL_VALUE "null"
#define XML_PAGEIDTYPE_VALUE "PageIdType"
#define XML_INDEX_VALUE "index"
#define XML_PINDEX_VALUE "primary"
#define XML_UINDEX_VALUE "unique"
#define XML_BTREE_VALUE "btree"
#define XML_PBTREE_VALUE "primbtree"
#define XML_UBTREE_VALUE "unibtree"
#define XML_ACTIVE_VALUE "ACTIVE"
#define XML_FREE_VALUE "FREE"
#define XML_OCCUPIED_VALUE "OCCUPIED"
#define XML_CLOSED_VALUE "VALUE"
#define XML_SYSTAB_VALUE "SYSTAB"
#define XML_APPTAB_VALUE "APPTAB"
#define XML_RECOVER_VALUE "RECOVER"
#define XML_ACTIVE_LOCKED_VALUE "ACTIVE_LOCKED"
#define XML_ON_VALUE "ON"
#define XML_OFF_VALUE "OFF"
#define XML_TRUE_VALUE "TRUE"
#define XML_FALSE_VALUE "FALSE"
#define XML_DBPRODNAME_VALUE CEGO_PRODUCT
#define XML_DBPRODVERSION_VALUE CEGO_VERSION
#define XML_SYSOBJ_VALUE "SYSOBJ"
#define XML_TABOBJ_VALUE "TABOBJ"
#define XML_PIXOBJ_VALUE "PIXOBJ"
#define XML_UIXOBJ_VALUE "UIXOBJ"
#define XML_IDXOBJ_VALUE "IDXOBJ"
#define XML_VIEWOBJ_VALUE "VIEWOBJ"
#define XML_JOINOBJ_VALUE "JOINOBJ"
#define XML_FKEYOBJ_VALUE "FKEYOBJ"
#define XML_CHECKOBJ_VALUE "CHECKOBJ"
#define XML_TRIGGEROBJ_VALUE "TRIGGEROBJ"
#define XML_ALIASOBJ_VALUE "ALIASOBJ"
#define XML_PROCOBJ_VALUE "PROCOBJ"
#define XML_RBSEGOBJ_VALUE "RBSEGOBJ"
#define XML_BTREEOBJ_VALUE "BTREEOBJ"
#define XML_PBTREEOBJ_VALUE "PBTREEOBJ"
#define XML_UBTREEOBJ_VALUE "UBTREEOBJ"
#define XML_READY_VALUE "READY"
#define XML_BUSY_VALUE "BUSY"
#define XML_CONNECTED_VALUE "CONNECTED"

// tableset run states
#define XML_DEFINED_VALUE "DEFINED"
#define XML_ONLINE_VALUE "ONLINE"
#define XML_OFFLINE_VALUE "OFFLINE"
#define XML_BACKUP_VALUE "BACKUP"
#define XML_RECOVERY_VALUE "RECOVERY"
#define XML_CHECKPOINT_VALUE "CHECKPOINT"

// tableset sync states
#define XML_NOT_SYNCHED_VALUE "NOT_SYNCHED"
#define XML_SYNCHED_VALUE "SYNCHED"
#define XML_ON_COPY_VALUE "ON_COPY"
#define XML_LOG_LOSS_VALUE "LOG_LOSS"

// role values
#define XML_ROLE_ALL_VALUE "ALL"
#define XML_ROLE_READOBJ_VALUE "READOBJ"
#define XML_ROLE_WRITEOBJ_VALUE "WRITEOBJ"
#define XML_ROLE_CREATEOBJ_VALUE "CREATEOBJ"
#define XML_ROLE_DROPOBJ_VALUE "DROPOBJ"
#define XML_ROLE_EXECPROC_VALUE "EXECPROC"

// lock cat values
#define XML_LOCK_REC_VALUE "LOCKREC"
#define XML_LOCK_RBREC_VALUE "LOCKRBREC"
#define XML_LOCK_SYSREC_VALUE "LOCKSYSREC"
#define XML_LOCK_THREADPOOL_VALUE "LOCKTHREADPOOL"
#define XML_LOCK_SYSPAGE_VALUE "LOCKSYSPAGE"
#define XML_LOCK_DATAPAGE_VALUE "LOCKDATAPAGE"
#define XML_LOCK_IDXPAGE_VALUE "LOCKIDXPAGE"
#define XML_LOCK_RBPAGE_VALUE "LOCKRBPAGE"
#define XML_LOCK_DATAFILE_VALUE "LOCKDATAFILE"
#define XML_LOCK_BUFFERPOOL_VALUE "LOCKBUFFERPOOL"
#define XML_LOCK_LOGMNG_VALUE "LOCKLOGMNG"
#define XML_LOCK_QUERYCACHE_VALUE "LOCKQUERYCACHE"
#define XML_LOCK_TABLECACHE_VALUE "LOCKTABLECACHE"

// prediacte encoding values
#define XML_AND_VALUE "AND"
#define XML_OR_VALUE "OR"
#define XML_EQUAL_VALUE "EQUAL"
#define XML_NOTEQUAL_VALUE "NOTEQUAL"
#define XML_LESSTHAN_VALUE "LESSTHAN"
#define XML_MORETHAN_VALUE "MORETHAN"
#define XML_LESSEQUALTHAN_VALUE "LESSEQUALTHAN" 
#define XML_MOREEQUALTHAN_VALUE "MOREEQUALTHAN" 
#define XML_NULLCOMP_VALUE "NULLCOMP"
#define XML_NOTNULLCOMP_VALUE "NOTNULLCOMP"
#define XML_EXISTS_VALUE "EXISTS"
#define XML_ISLIKE_VALUE "ISLIKE"
#define XML_ISNOTLIKE_VALUE "ISNOTLIKE"
#define XML_IN_VALUE "IN"
#define XML_NOTIN_VALUE "NOTIN"
#define XML_INQUERY_VALUE "INQUERY"
#define XML_NOTINQUERY_VALUE "NOTINQUERY"
#define XML_PLUS_VALUE "PLUS"
#define XML_SUB_VALUE "SUB"
#define XML_CONCAT_VALUE "CONCAT"
#define XML_TERM_VALUE "TERM"
#define XML_COND_VALUE "COND"
#define XML_PRED_VALUE "PRED"
#define XML_NOTPRED_VALUE "NOTPRED"
#define XML_MUL_VALUE "MUL"
#define XML_DIV_VALUE "DIV"
#define XML_FACTOR_VALUE "FACTOR"
#define XML_CONST_VALUE "CONST"
#define XML_ATTR_VALUE "ATTR"
#define XML_VAR_VALUE "VAR"
#define XML_EXPR_VALUE "EXPR"
#define XML_FETCH_VALUE "FETCH"
#define XML_EXPRCOMP_VALUE "EXPRCOMP"
#define XML_BETWEEN_VALUE "BETWEEN"
#define XML_FETCH_VALUE "FETCH"
#define XML_AGGREGATION_VALUE "AGGREGATION"
#define XML_FUNCTION_VALUE "FUNCTION"
#define XML_QUERY_VALUE "QUERY"
#define XML_SELECT_VALUE "SELECT"
#define XML_ADD_VALUE "ADD"
#define XML_MODIFY_COLUMN_VALUE "MODIFY_COLUMN"
#define XML_MODIFY_DEFAULT_VALUE "MODIFY_DEFAULT"
#define XML_DROP_VALUE "DROP"
#define XML_RENAME_VALUE "RENAME"
#define XML_INT2ASCFUNC_VALUE "INT2ASCFUNC"
#define XML_ASC2INTFUNC_VALUE "ASC2INTFUNC"
#define XML_TRIMFUNC_VALUE "TRIMFUNC"
#define XML_RTRIMFUNC_VALUE "RTRIMFUNC"
#define XML_LTRIMFUNC_VALUE "LTRIMFUNC"
#define XML_ROUNDFUNC_VALUE "ROUND"
#define XML_TRUNCFUNC_VALUE "TRUNCFUNC"
#define XML_SCANDATEFUNC_VALUE "SCANDATEFUNC"
#define XML_DATE2STRFUNC_VALUE "DATE2STRFUNC"
#define XML_DATE2LONGFUNC_VALUE "DATE2LONGFUNC"
#define XML_LONG2DATEFUNC_VALUE "LONG2DATEFUNC"
#define XML_NEWDATEFUNC_VALUE "NEWDATEFUNC"
#define XML_LOWERFUNC_VALUE "LOWERFUNC"
#define XML_UPPERFUNC_VALUE "UPPERFUNC"
#define XML_LEFTFUNC_VALUE "LEFTFUNC"
#define XML_RIGHTFUNC_VALUE "RIGHTFUNC"
#define XML_SUBSTRFUNC_VALUE "SUBSTRFUNC"
#define XML_GETPOSFUNC_VALUE "GETPOSFUNC"
#define XML_STR2INTFUNC_VALUE "STR2INTFUNC"
#define XML_STR2LONGFUNC_VALUE "STR2LONGFUNC"
#define XML_RANDSTRFUNC_VALUE "RANDSTRFUNC"
#define XML_RANDINTFUNC_VALUE "RANDINTFUNC"
#define XML_REPLACEFUNC_VALUE "REPLACEFUNC"
#define XML_LENGTHFUNC_VALUE "LENGTHFUNC"
#define XML_MODFUNC_VALUE "MODFUNC"
#define XML_DIVFUNC_VALUE "DIVFUNC"
#define XML_LMODFUNC_VALUE "LMODFUNC"
#define XML_LDIVFUNC_VALUE "LDIVFUNC"
#define XML_POWERFUNC_VALUE "POWERFUNC"
#define XML_BITANDFUNC_VALUE "BITANDFUNC"
#define XML_BITORFUNC_VALUE "BITORFUNC"
#define XML_BITXORFUNC_VALUE "BITXORFUNC"
#define XML_BLOBSIZEFUNC_VALUE "BLOBSIZEFUNC"
#define XML_BLOBREFFUNC_VALUE "BLOBREFFUNC"
#define XML_CLOBSIZEFUNC_VALUE "CLOBSIZEFUNC"
#define XML_CLOBREFFUNC_VALUE "CLOBREFFUNC"
#define XML_CLOB2STRFUNC_VALUE "CLOB2STRFUNC"
#define XML_NEXTCOUNTFUNC_VALUE "NEXTCOUNT"
#define XML_SETCOUNTFUNC_VALUE "SETCOUNT"
#define XML_GETCOUNTFUNC_VALUE "GETCOUNT"
#define XML_USERDEFINEDFUNC_VALUE "USERDEFINEDFUNC"
#define XML_TABLE_VALUE "TABLE"
#define XML_VIEW_VALUE "VIEW"
#define XML_ALIAS_VALUE "ALIAS"
#define XML_INNERJOIN_VALUE "INNERJOIN"
#define XML_LEFTOUTERJOIN_VALUE "LEFTOUTERJOIN"
#define XML_RIGHTOUTERJOIN_VALUE "RIGHTOUTERJOIN"
#define XML_APPFILE_VALUE "APP"
#define XML_TEMPFILE_VALUE "TEMP"
#define XML_SYSFILE_VALUE "SYS"
#define XML_MIN_VALUE "MIN"
#define XML_MAX_VALUE "MAX"
#define XML_SUM_VALUE "SUM"
#define XML_AVG_VALUE "AVG"
#define XML_COUNT_VALUE "COUNT"
#define XML_XML_VALUE "XML"
#define XML_BIN_VALUE "BIN"
#define XML_PLAIN_VALUE "PLAIN"
#define XML_BLOBPREFIX "B@"
#define XML_CLOBPREFIX "C@"
#define XML_NOTICE_VALUE "NOTICE"
#define XML_LOGERR_VALUE "LOGERR"
#define XML_DEBUG_VALUE "DEBUG"
#define XML_NONE_VALUE "NONE"
#define XML_STR_VALUE "STR"
#define XML_ID_VALUE "ID"
#define XML_ADMIN_ROLE "admin"
#define XML_CREATE_ROLE "create"
#define XML_MODIFY_ROLE "modify"
#define XML_READ_ROLE "read"
#define XML_DROP_ROLE "drop"

#define XML_ROUND_DOWN "DOWN"
#define XML_ROUND_UP "UP"
#define XML_ROUND_HALFDOWN "HALFDOWN"
#define XML_ROUND_HALFUP "HALFUP"


#endif
