#!/bin/sh

ACTIVETSLIST=sysmt,lit
STARTTIMEOUT=30

STARTTIME=`date '+%s'`

doWait=yes

while [ $doWait == "yes" ]
do

    # at the beginning, we are optimnistic
    doWait=no
    
    for TSSTAT in `cgadm --server=bigmac.local --port=2000 --user=cgadm/cgadm --raw --cmd="list tableset"`
    do
	
	CURTS=`echo $TSSTAT | awk -F, '{ print $1 }'`
	CURSTAT=`echo $TSSTAT | awk -F, '{ print $2 }'`
	
	tslist=$(echo $ACTIVETSLIST | tr "," "\n")
	for ts in $tslist
	do
	    if [ $ts == $CURTS ]
	    then
		# if tableset state not online, do wait
		if [ $CURSTAT != "ONLINE" ]
		then
		    doWait=yes
		fi
	    fi
	done
    done

    # check timeout

    CURRENTTIME=`date '+%s'`
    DELAY=`expr $CURRENTTIME - $STARTTIME`
    
    if [[ "$DELAY" -gt "$STARTTIMEOUT" ]]
    then
	echo "Timeout occured"
	doWait=no
    fi
    
    if [ $doWait == "yes" ]
    then
	# wait 3 seconds before performing next online check
	sleep 3
    fi
done
