--
-- ### Sample FW application with complex join
--

drop if exists counter userid;
create counter userid;
set counter userid to 2;
drop if exists counter srvid;
create counter srvid;
set counter srvid to 2;
drop if exists counter hostid;
create counter hostid;
set counter hostid to 47;
drop if exists counter sysid;
create counter sysid;
set counter sysid to 4;
drop if exists counter sgid;
create counter sgid;
set counter sgid to 20;
drop if exists counter pgid;
create counter pgid;
set counter pgid to 3;
drop if exists counter fwrid;
create counter fwrid;
set counter fwrid to 0;
drop if exists counter fwid;
create counter fwid;
set counter fwid to 7;

drop if exists table erp_firewall;
create table erp_firewall(fwid int not null, srvid int not null, sgidfrom int, sgidto int, pgid int, location string(20));
insert into erp_firewall values (6, 2, 13, 12, 3, 'ABC');
insert into erp_firewall values (4, 2, 4, 1, 1, 'DXC');
insert into erp_firewall values (5, 2, 5, 1, 2, 'FAC');
insert into erp_firewall values (7, 2, 13, 12, 1, 'PAC');

drop if exists table erp_fwrule;
create table erp_fwrule(fwrid int not null, sgid_from int, sgid_to int, pgid int);

drop if exists table erp_system;
create table erp_system(sysid int not null, sid string(10) not null, srvid int not null);
insert into erp_system values (1, 'DXX', 2);
insert into erp_system values (2, 'PXX', 2);
insert into erp_system values (3, 'QXX', 2);
insert into erp_system values (4, 'ALF', 1);

drop if exists table erp_service;
create table erp_service(srvid int not null, srvname string(100) not null, srvdesc string(3000));
insert into erp_service values (2, 'cbFC', null);
insert into erp_service values (1, 'xxxyService', null);

drop if exists table erp_host2group;
create table erp_host2group(sgid int not null, hostid int not null, serverdesc string(3000));
insert into erp_host2group values (1, 9, null);
insert into erp_host2group values (12, 11, null);
insert into erp_host2group values (1, 4, null);
insert into erp_host2group values (1, 6, null);
insert into erp_host2group values (1, 1, null);
insert into erp_host2group values (1, 10, null);
insert into erp_host2group values (4, 9, null);
insert into erp_host2group values (4, 4, null);
insert into erp_host2group values (12, 15, null);
insert into erp_host2group values (13, 9, null);
insert into erp_host2group values (13, 2, null);
insert into erp_host2group values (14, 17, null);
insert into erp_host2group values (14, 22, null);
insert into erp_host2group values (14, 20, null);
insert into erp_host2group values (14, 18, null);
insert into erp_host2group values (14, 21, null);
insert into erp_host2group values (14, 16, null);
insert into erp_host2group values (14, 19, null);
insert into erp_host2group values (14, 23, null);
insert into erp_host2group values (14, 24, null);
insert into erp_host2group values (15, 26, null);
insert into erp_host2group values (15, 27, null);
insert into erp_host2group values (16, 28, null);
insert into erp_host2group values (17, 30, null);
insert into erp_host2group values (17, 29, null);
insert into erp_host2group values (18, 31, null);
insert into erp_host2group values (18, 32, null);
insert into erp_host2group values (19, 33, null);
insert into erp_host2group values (19, 34, null);
insert into erp_host2group values (19, 35, null);
insert into erp_host2group values (20, 30, null);
insert into erp_host2group values (20, 29, null);

drop if exists table erp_servergroup;
create table erp_servergroup(sgid int not null, sgname string(100), sgdesc string(3000));
insert into erp_servergroup values (10, 'EMON.XXX.servers-prod', 'xxxx');
insert into erp_servergroup values (6, 'Client XXX networks', 'Client Group');
insert into erp_servergroup values (12, 'SAP-GROUP', 'xxx');
insert into erp_servergroup values (3, 'FA.EM1.all', 'NA');
insert into erp_servergroup values (9, 'FA networks', 'xxxx');
insert into erp_servergroup values (7, 'ALL.EMXservers', 'XXX');
insert into erp_servergroup values (4, 'ALL.sap-systems', 'ISN rule');
insert into erp_servergroup values (2, 'XAN.EM-monitoring', 'ISN server group');
insert into erp_servergroup values (11, 'N.XXX', 'Unklar');
insert into erp_servergroup values (13, 'SAP-GROUP', 'xxx');
insert into erp_servergroup values (14, 'TTT.XX.sapservers', 'XX SAP servers in XX');
insert into erp_servergroup values (15, 'TTT.X.webservers-intra', 'ISN WebServers');
insert into erp_servergroup values (16, 'TTT.X.middleware-zzz', 'Middleware ZZZ');
insert into erp_servergroup values (17, 'TTT.X.middleware-xxx', 'Middleware XXX');
insert into erp_servergroup values (18, 'TTT.XYZ-sapserver', 'XYZ SAP Server');
insert into erp_servergroup values (19, 'TTT.ZZZ.sapserver', 'ZZZ Server');
insert into erp_servergroup values (20, 'TTT.PPP.sapserver', 'xxx');

drop if exists table erp_portgroup;
create table erp_portgroup(pgid int not null, pgname string(100), pgdesc string(3000));
insert into erp_portgroup values (1, 'ABC', null);
insert into erp_portgroup values (2, 'YPORT', null);
insert into erp_portgroup values (3, 'NFS-PORT', null);

drop if exists table erp_sys2host;
create table erp_sys2host(sysid int not null, hostid int not null);
insert into erp_sys2host values (2, 11);
insert into erp_sys2host values (1, 1);
insert into erp_sys2host values (3, 9);
insert into erp_sys2host values (3, 2);
insert into erp_sys2host values (4, 9);
insert into erp_sys2host values (2, 7);

drop if exists table erp_server2group;
create table erp_server2group(sgid int not null, hostid int not null, serverdesc string(3000));

drop if exists table erp_port2group;
create table erp_port2group(pgid int not null, portdef string(100) not null, portdesc string(3000));
insert into erp_port2group values (1, '4711', null);
insert into erp_port2group values (1, '4712', null);
insert into erp_port2group values (2, '456', null);
insert into erp_port2group values (2, '543', null);
insert into erp_port2group values (3, '2049', null);
insert into erp_port2group values (3, 'ddddd', null);

drop if exists table erp_host;
create table erp_host(hostid int not null, hostname string(100), hostadr string(100), hostpvlan string(100));
insert into erp_host values (10, '99.66.X.X', null, null);
insert into erp_host values (4, 'vpadt005.xx.sample.net', '94.30.243.99', null);
insert into erp_host values (6, 'vpadt006.xx.sample.net', null, null);
insert into erp_host values (1, 'sxxxcbf00.emea.ebs.sample.net', '94.20.21.82', 'XXX');
insert into erp_host values (11, 'sxxxecbf310.emea.isn.sample.net', '94.71.17.95', null);
insert into erp_host values (16, 's96tttc1.xxx.sample.net', '94.71.80.141', null);
insert into erp_host values (7, 'sttt2.xxx.sample.net', '94.71.80.294\n', null);
insert into erp_host values (2, 'xxxx102.fdc.sample.net', '94.18.243.218', null);
insert into erp_host values (15, 'axooidb.isn.sample.net', '94.71.17.96\n', null);
insert into erp_host values (17, 'ppplll.xxx.sample.net', '94.71.80.143', null);
insert into erp_host values (9, 'ffff.usfdc.sample.net', '94.18.243.220', null);
insert into erp_host values (18, 'sffeeec2.xxx.sample.net', '94.71.80.142', null);
insert into erp_host values (19, 'gggg.usfdc.sample.net', '94.18.243.181', null);
insert into erp_host values (20, 'vcbdtqn1.us.sample.net', '94.18.243.184', null);
insert into erp_host values (21, 'zcbdt103.us.sample.net', '94.18.243.227', null);
insert into erp_host values (22, 'vcbdtqn2.us.sample.net', '94.18.243.228', null);
insert into erp_host values (23, 'zcbdt101.us.sample.net', '94.18.243.174', null);
insert into erp_host values (24, 'vcbdtpn1.us.sample.net', '94.18.243.175', null);
insert into erp_host values (26, 'lodasxx-int.isn.sample.net', '94.71.106.193', null);
insert into erp_host values (27, 'lodasxx.isn.sample.net', '94.71.106.192', null);
insert into erp_host values (28, 'sxxxb299.emea.isn.sample.net', '94.71.238.76', null);
insert into erp_host values (29, 'zpdt890.us.sample.net', '94.18.243.95', null);
insert into erp_host values (18, 'vpadxx89.us.sample.net', '94.18.243.96', null);
insert into erp_host values (31, 'a138xxxidb.us.sample.net', '94.68.128.79', null);
insert into erp_host values (32, 'd138bxxap669.us.sample.net', '94.68.128.75', null);
insert into erp_host values (33, 'sxxxana150.emea.ebs.sample.net', '94.20.22.232', null);
insert into erp_host values (34, 'sxxxana140.emea.ebs.sample.net', '94.20.22.231', null);
insert into erp_host values (35, 'sxxxana118.emea.ebs.sample.net', '94.20.22.218', null);
insert into erp_host values (38, 'zcbdt213.us.sample.net', '94.18.243.154', null);
insert into erp_host values (39, 'vxxxdtap4.us.sample.net', '94.18.243.168', null);
insert into erp_host values (40, 'vddtap5.us.sample.net', '94.18.243.169', null);
insert into erp_host values (41, 'zrrrdt112.us.sample.net', '94.18.243.189', null);
insert into erp_host values (42, 'vrrsstap1.us.sample.net', '94.18.243.190', null);
insert into erp_host values (43, 'zewew132.us.sample.net', '94.18.243.192', null);
insert into erp_host values (44, 'fdsfdsap2.us.sample.net', '94.18.243.193', null);
insert into erp_host values (45, 'ooooo32.us.sample.net', '94.18.243.195', null);
insert into erp_host values (46, 'ppppp3.us.sample.net', '94.18.243.196', null);
insert into erp_host values (47, 'wrwrwr12.us.sample.net', '94.18.243.232', null);

drop if exists table erp_user;
create table erp_user(userid int not null, userlogname string(100), userfirstname string(100), userlastname string(100), userrole string(100), userpasswd string(100), userhostinfo string(100));
insert into erp_user values (1, 'lemke', 'NA', 'NA', 'admin', 'NA', '94.71.122.172');

drop if exists btree erp_firewall_pbtree;
create btree erp_firewall_pbtree on erp_firewall(fwid);

drop if exists btree erp_firewall_b1;
create btree erp_firewall_b1 on erp_firewall(srvid);

drop if exists btree erp_firewall_b2;
create btree erp_firewall_b2 on erp_firewall(sgidfrom);

drop if exists btree erp_firewall_b3;
create btree erp_firewall_b3 on erp_firewall(sgidto);

drop if exists btree erp_firewall_b4;
create btree erp_firewall_b4 on erp_firewall(pgid);

drop if exists btree erp_fwrule_pbtree;
create btree erp_fwrule_pbtree on erp_fwrule(fwrid);

drop if exists btree erp_system_pbtree;
create btree erp_system_pbtree on erp_system(sysid);

drop if exists btree erp_system_b1;
create btree erp_system_b1 on erp_system(sid);

drop if exists btree erp_system_b2;
create btree erp_system_b2 on erp_system(srvid);

drop if exists btree erp_service_b1;
create btree erp_service_b1 on erp_service(srvname);

drop if exists btree erp_host2group_pbtree;
create btree erp_host2group_pbtree on erp_host2group(sgid,hostid);

drop if exists btree erp_service_pbtree;
create btree erp_service_pbtree on erp_service(srvid);

drop if exists btree erp_host2group_b1;
create btree erp_host2group_b1 on erp_host2group(sgid);

drop if exists btree erp_host2group_b2;
create btree erp_host2group_b2 on erp_host2group(hostid);

drop if exists btree erp_servergroup_pbtree;
create btree erp_servergroup_pbtree on erp_servergroup(sgid);

drop if exists btree erp_servergroup_b1;
create btree erp_servergroup_b1 on erp_servergroup(sgname);

drop if exists btree erp_portgroup_pbtree;
create btree erp_portgroup_pbtree on erp_portgroup(pgid);

drop if exists btree erp_portgroup_b1;
create btree erp_portgroup_b1 on erp_portgroup(pgname);

drop if exists btree erp_sys2host_pbtree;
create btree erp_sys2host_pbtree on erp_sys2host(sysid,hostid);

drop if exists btree erp_server2group_pbtree;
create btree erp_server2group_pbtree on erp_server2group(sgid,hostid);

drop if exists btree erp_port2group_pbtree;
create btree erp_port2group_pbtree on erp_port2group(pgid,portdef);

drop if exists btree erp_host_pbtree;
create btree erp_host_pbtree on erp_host(hostid);

drop if exists btree erp_host_b1;
create btree erp_host_b1 on erp_host(hostname);

drop if exists btree erp_user_pbtree;
create btree erp_user_pbtree on erp_user(userid);

drop if exists btree erp_user_b1;
create btree erp_user_b1 on erp_user(userlogname);

drop if exists view erp_sgview;
create view erp_sgview as
select
 sg.sgid as sgid,
 sg.sgname as sgname,
 h.hostname as hostname
from
 erp_servergroup sg,
 erp_host2group h2g,
 erp_host h
where
 ( sg.sgid = h2g.sgid
  and
 h2g.hostid = h.hostid );

drop if exists view erp_sidfw;
create view erp_sidfw as
select
 fw.fwid as fwid,
 sysfrom.sid as sidfrom,
 systo.sid as sidto,
 sgfrom.sgname as sgfrom,
 sgto.sgname as sgto,
 hostfrom.hostname as hostfrom,
 hostto.hostname as hostto,
 pg.pgname as pgname,
 case when ( sysfrom.srvid != systo.srvid
 and
rtrim(hostfrom.hostadr,'0123456789') = rtrim(hostto.hostadr,'0123456789') ) then 'INVALID' else 'VALID' end  as status
from
 erp_service srvfrom,
 erp_service srvto,
 erp_system sysfrom,
 erp_system systo,
 erp_sys2host s2hfrom,
 erp_sys2host s2hto,
 erp_host hostfrom,
 erp_host hostto,
 erp_host2group h2gfrom,
 erp_host2group h2gto,
 erp_servergroup sgfrom,
 erp_servergroup sgto,
 erp_firewall fw,
 erp_portgroup pg
where
 ( ( ( ( ( ( ( ( ( ( ( ( fw.pgid = pg.pgid
 and
fw.sgidfrom = sgfrom.sgid )
 and
fw.sgidto = sgto.sgid )
 and
sgfrom.sgid = h2gfrom.sgid )
 and
sgto.sgid = h2gto.sgid )
 and
s2hfrom.hostid = h2gfrom.hostid )
 and
s2hto.hostid = h2gto.hostid )
 and
s2hfrom.hostid = hostfrom.hostid )
 and
s2hto.hostid = hostto.hostid )
 and
sysfrom.sysid = s2hfrom.sysid )
 and
systo.sysid = s2hto.sysid )
 and
srvfrom.srvid = sysfrom.srvid )
  and
 srvto.srvid = systo.srvid );

drop if exists view erp_fwview;
create view erp_fwview as
select
 fw.fwid as fwid,
 s.srvname as srvname,
 sgf.sgname as sgfrom,
 sgt.sgname as sgto,
 pg.pgname as pgname,
 fw.location as location
from
 erp_firewall fw,
 erp_service s,
 erp_servergroup sgf,
 erp_servergroup sgt,
 erp_portgroup pg
where
 ( ( ( fw.srvid = s.srvid
 and
fw.sgidfrom = sgf.sgid )
 and
fw.sgidto = sgt.sgid )
  and
 pg.pgid = fw.pgid );

drop if exists view erp_systemview;
create view erp_systemview as
select
 s.sysid as sysid,
 s.sid as sid,
 sv.srvname as srvname
from
 erp_system s,
 erp_service sv
where
 s.srvid = sv.srvid;

drop if exists procedure newSystem;
@
create procedure newSystem(sid in string(10),
     srvname in string(100)) return int
begin
   var sysid int;
   var srvid int;
   :srvid = (select
 erp_service.srvid as srvid
from
 erp_service erp_service
where
 erp_service.srvname = :srvname
);
   :sysid = nextcount(sysid);
   insert into erp_system ( sysid, sid, srvid )
    values (:sysid, :sid, :srvid);
   return :sysid;
end;
@

drop if exists procedure newService;
@
create procedure newService(srvname in string(100)) return int
begin
   var srvid int;
   :srvid = nextcount(srvid);
   insert into erp_service ( srvid, srvname )
    values (:srvid, :srvname);
   return :srvid;
end;
@

drop if exists procedure newServerGroup;
@
create procedure newServerGroup(sgname in string(100),
     sgdesc in string(1800)) return int
begin
   var sgid int;
   :sgid = nextcount(sgid);
   insert into erp_servergroup ( sgid, sgname, sgdesc )
    values (:sgid, :sgname, :sgdesc);
   return :sgid;
end;
@

drop if exists procedure newPortGroup;
@
create procedure newPortGroup(pgname in string(100),
     pgdesc in string(3000)) return int
begin
   var pgid int;
   :pgid = nextcount(pgid);
   insert into erp_portgroup ( pgid, pgname, pgdesc )
    values (:pgid, :pgname, :pgdesc);
   return :pgid;
end;
@

drop if exists procedure newHost;
@
create procedure newHost(hostname in string(100)) return int
begin
   var hostid int;
   :hostid = nextcount(hostid);
   insert into erp_host ( hostid, hostname )
    values (:hostid, :hostname);
   return :hostid;
end;
@

drop if exists procedure newUser;
@
create procedure newUser(userlogname in string(100),
     userfirstname in string(100),
     userlastname in string(100),
     userrole in string(100)) return int
begin
   var userid int;
   :userid = nextcount(userid);
   insert into erp_user ( userid, userlogname, userfirstname, userlastname, userrole )
    values (:userid, :userlogname, :userfirstname, :userlastname, :userrole);
   return :userid;
end;
@

drop if exists procedure newFirewall;
@
create procedure newFirewall(srvname in string(100),
     sgfrom in string(100),
     sgto in string(100),
     pgname in string(100)) return int
begin
   var srvid int;
   var sgid_from int;
   var sgid_to int;
   var pgid int;
   var fwid int;
   :fwid = nextcount(fwid);
   :srvid = (select
 erp_service.srvid as srvid
from
 erp_service erp_service
where
 erp_service.srvname = :srvname
);
   :sgid_from = (select
 erp_servergroup.sgid as sgid
from
 erp_servergroup erp_servergroup
where
 erp_servergroup.sgname = :sgfrom
);
   :sgid_to = (select
 erp_servergroup.sgid as sgid
from
 erp_servergroup erp_servergroup
where
 erp_servergroup.sgname = :sgto
);
   :pgid = (select
 erp_portgroup.pgid as pgid
from
 erp_portgroup erp_portgroup
where
 erp_portgroup.pgname = :pgname
);
   insert into erp_firewall ( fwid, srvid, sgidfrom, sgidto, pgid )
    values (:fwid, :srvid, :sgid_from, :sgid_to, :pgid);
   return :fwid;
end;
@

select * from erp_sidfw;
select * from erp_sidfw where status = 'VALID';
