--
-- ### Trigger checks
--

drop if exists table t1;
create table t1 ( a int, b string(30));

drop if exists table t2;
create table t2 ( c int, d string(30));

drop if exists table t3;
create table t3 ( m string(50));

@
create trigger tg1 before insert on t1
begin
	-- while t1 in increasing, t2 is decreasing
	delete from t2 where c = a;	
end;
@

@
create trigger tg2 before update on t1
begin
	-- store update protocol in t3
	var s string(30);
	:s = 'T1 updated at ' | sysdate | ' to ' | b;
	insert into t3 values ( :s );	
end;
@


list trigger;
show trigger tg1;
show trigger tg2;

insert into t2 values ( 1, 'XXX');
insert into t2 values ( 2, 'XXX');
insert into t2 values ( 3, 'XXX');
insert into t2 values ( 4, 'XXX');

insert into t1 values ( 1, 'HUGO');
select * from t2;

insert into t1 values ( 2, 'HUGO');
select * from t2;

insert into t1 values ( 3, 'HUGO');
select * from t2;

select * from t3;
update t1 set b = 'Bert' where a = 1;
update t1 set b = 'Gabi';
update t1 set b = 'Werner';	
select * from t3;
