#ifndef _CEGOBTREEOBJECT_H_INCLUDED_
#define _CEGOBTREEOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeObject.h
// ------------------
// Cego btree object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBTreeObject
// 
// Description: Binary tree index structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoDefs.h"
#include "CegoField.h"
#include "CegoContentObject.h"

class CegoBTreeObject : public CegoContentObject {

public:

    CegoBTreeObject();
    CegoBTreeObject(const CegoBTreeObject& oe);
    CegoBTreeObject(int tabSetId, ObjectType type, const Chain& objName);
    CegoBTreeObject(int tabSetId, ObjectType type, const Chain& objName, const ListT<CegoField>& schema, const Chain& tabName);
    
    ~CegoBTreeObject();
    
    void setDataPageId(PageIdType pageId);
    PageIdType getDataPageId() const;
    
    void increaseRelevance();
    void decreaseRelevance();
    int getRelevance() const;
    
    int getEntrySize() const;

    void encode(char *buf) const;
    void decode(char *buf);

    bool isValid(); 

    void setSchema(const ListT<CegoField>& schema);   
    
    CegoBTreeObject& operator = ( const CegoBTreeObject& oe);
    bool operator == ( const CegoBTreeObject& oe);

    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(int defTabSetId) const;
    CegoContentObject* clone(bool isAttrRef = false);
    
    Chain getInfo() const;
    
private:

    PageIdType _pageId;
    int _relevance; 
};
#endif
