#ifndef _CEGOBEATCONNECTION_H_INCLUDED_
#define _CEGOBEATCONNECTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBeatConnection.h
// --------------------
// Cego beat connection class defintion
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBeatConnection
//
// Description: Utility class for cego nodes heart beat connection
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/Logger.h>
#include <lfcbase/NetHandler.h>

// CEGO INCLUDES
#include "CegoDatabaseManager.h"
#include "CegoAdminHandler.h"

class CegoBeatConnection {

public:

    CegoBeatConnection();

    CegoBeatConnection(const Chain& hostName);
    CegoBeatConnection(const Chain& hostName, int portNo, const Chain& user, const Chain& passwd, CegoDatabaseManager *pModule);

    ~CegoBeatConnection();

    void setHostName(const Chain& hostName);
    const Chain& getHostName() const;

    void setPortNo(int portNo);
    int getPortNo() const;

    void setUser(const Chain& user);    
    const Chain& getUser() const;

    void setPasswd(const Chain& passwd);    
    const Chain& getPasswd() const;

    void connect();
    void disconnect();
    void beat(const ListT<Chain>& tsList, const ListT<Chain>& runList, const ListT<Chain>& syncList);

    CegoBeatConnection& operator = ( const CegoBeatConnection& mc);
    bool operator == ( const CegoBeatConnection& mc);

    friend ostream& operator << (ostream& s, const CegoBeatConnection& mc);
    
private:
    
    Chain _hostName;
    int _portNo;
    Chain _user;
    Chain _passwd;

    NetHandler* _pN;
    CegoAdminHandler* _pAdminHandle;
    CegoDatabaseManager* _pDBMng;

    unsigned long _modId;
};
#endif
