#ifndef _CEGOLOGRECORD_H_INCLUDED_
#define _CEGOLOGRECORD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogRecord.h
// ---------------
// Cego Log Record structure definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoLogRecord
// 
// Description: Log record data structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoDefs.h"
#include "CegoObject.h"

class CegoLogRecord {

public:
    
    enum LogAction { LOGREC_CREATE, 
		     LOGREC_DROP, 
		     LOGREC_ALTER, 
		     LOGREC_RENAME, 
		     LOGREC_INSERT,
		     LOGREC_DELETE,
		     LOGREC_UPDATE, 
		     LOGREC_BEGIN, 
		     LOGREC_COMMIT, 
		     LOGREC_ABORT, 
		     LOGREC_SYNC, 
		     LOGREC_BUPAGE,
		     LOGREC_BUFBM, 
		     LOGREC_BUFIN,
		     LOGREC_ADDCOUNTER,
		     LOGREC_DELCOUNTER,
    		     LOGREC_TRUNCATE };

    CegoLogRecord();
    ~CegoLogRecord();

    unsigned long long getLSN() const;
    void setLSN(unsigned long long lsn);
    long long getTS() const;
    void setTS(long long ts);
    unsigned long long getTID() const;
    void setTID(unsigned long long tid);
    unsigned long long getTAStep() const;
    void setTAStep(unsigned long long tastep);
    void setObjectInfo(const Chain& objName, CegoObject::ObjectType type);
    const Chain& getObjName() const;
    CegoObject::ObjectType getObjType() const;
    LogAction getAction() const;
    void setAction(LogAction a);
    char* getData() const;
    void setData(char* data);
    int getDataLen() const;
    void setDataLen(int l);
    int getFileId() const;
    void setFileId(int fileId);
    PageIdType getPageId() const;
    void setPageId(PageIdType pageId);
    int getEncodingLength() const;
    void encode(void* p) const;
    void decode(void* p);
    void decodeLSN(void* p);
    void decodeLogAction(void* p);
    void clean();
    Chain toChain() const;
    
    CegoLogRecord& operator = ( const CegoLogRecord& d);    
    friend ostream& operator << (ostream& s, const CegoLogRecord& logRecord);

private:
    
    unsigned long long _lsn;
    unsigned long long _tid;
    unsigned long long _tastep;
    Chain _objName;
    CegoObject::ObjectType _objType;
    enum LogAction _logAction;
    int _dataLen;
    char* _data;
    bool _encObj;
    // for file BM logging
    int _fileId;
    // for page logging 
    PageIdType _pageId;
    long long _ts;
};
#endif
