#ifndef _CEGOORDERSPACE_H_INCLUDED_
#define _CEGOORDERSPACE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderSpace.h
// ----------------
// Cego order space class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoOrderSpace
// 
// Description: Utility class for tuple sorting 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoDefs.h"
#include "CegoAttrDesc.h"
#include "CegoOrderNode.h"
#include "CegoOrderCursor.h"
#include "CegoQueryHelper.h"

// forward declaration
// class CegoTableManager;

class CegoOrderSpace {
    
 public:
    
    CegoOrderSpace();
    ~CegoOrderSpace();
       
    void initOrderSpace(ListT<CegoExpr*> *pOrderList, ListT<CegoOrderNode::Ordering> *pOrderOptList, unsigned long long maxOrderSize);
    void insertTuple(ListT<CegoField>& orderKey, ListT<CegoField>& orderTuple);
    void resetOrderSpace();
    CegoOrderCursor* getCursor();
    unsigned long long numAllocated() const;
 
 private:

    void setAggregationValue(CegoExpr *pExpr, ListT<CegoField>& fl);
    ListT<CegoExpr*>* _pOrderList;
    ListT<CegoOrderNode::Ordering>* _pOrderOptList;

    AVLTreeT<CegoOrderNode>* _pAVL;
    bool _schemaSet;
    ListT<CegoField> _selectSchema;
    ListT<CegoField> _orderSchema;
    unsigned long long _maxOrderSize;
    unsigned long long _orderSize;
};
#endif
