///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcIfStmt.cc  
// -----------------    
// Cego procedure if statement class implementation
//                                                 
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcIfStmt
// 
// Description: Stored procedure if-statement block handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcIfStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcIfStmt::CegoProcIfStmt(ListT<CegoPredicate*>& predList,
				   ListT<CegoProcBlock*>& ifBlockList,
				   CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _predList = predList;
    _ifBlockList = ifBlockList;
    _pBlock = pBlock;
}

CegoProcIfStmt::~CegoProcIfStmt()  
{
    CegoPredicate** pPred = _predList.First();
    
    while  ( pPred )
    {
	delete *pPred;
	pPred = _predList.Next();
    }

    CegoProcBlock** pBlock = _ifBlockList.First();
    while ( pBlock )
    {
	delete *pBlock;
	pBlock = _ifBlockList.Next();
    }  
}

CegoException CegoProcIfStmt::execute()
{
    CegoPredicate** pPred = _predList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    while ( pPred )
    {	
	// (*pPred)->setBlock(_pBlock);

	try
	{
	    if ( (*pPred)->eval(0,0,0,0, _pBlock) == true )
	    {
		return (*pBlock)->execute();		
	    }
	    else
	    {
		pPred = _predList.Next();
		pBlock = _ifBlockList.Next();
	    }
	}
	catch ( Exception e )
	{
	    Chain excepMsg = e.getBaseMsg();	    
	    getParentBlock()->setExceptionMsg(excepMsg);
	    return COREOP_EXCEP;
	}
    }
    
    if ( pBlock )
    { 
	return (*pBlock)->execute();
    }
    
    return NONE_EXCEP;
}

void CegoProcIfStmt::cleanUp()
{
    CegoPredicate** pPred = _predList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    while ( pPred )
    {	
	(*pPred)->cleanUp();
	(*pBlock)->cleanUp();
		
	pPred = _predList.Next();
	pBlock = _ifBlockList.Next();
    }
    
    if ( pBlock )
    { 
	return (*pBlock)->cleanUp();
    }
}
	
Chain CegoProcIfStmt::toChain(int defTabSetId, const Chain& indent) const
{
    Chain s;

    CegoPredicate** pPred = _predList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    s = indent + Chain("if ");
    
    while ( pPred )
    {
	s += (*pPred)->toChain(defTabSetId);	
	s += Chain("\n") + indent + Chain("then\n");	    
	s += (*pBlock)->toChain(defTabSetId, indent + Chain(DEFAULTINDENT));
	
	pPred = _predList.Next();
	pBlock = _ifBlockList.Next();
	if ( pPred )
	    s += indent + Chain("elsif ");
	else if ( pBlock == 0 )
	    s += indent + Chain("end");
    }
    if ( pBlock )
    {
	s += indent + Chain("else\n");
	s += (*pBlock)->toChain(defTabSetId, indent + Chain(DEFAULTINDENT));
	s += indent + Chain("end");
    }

    return s;
}

Chain CegoProcIfStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcIfStmt(_predList, _ifBlockList);
}

bool CegoProcIfStmt::isStatic() const
{
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    while ( pBlock )
    {
	if ( (*pBlock)->isStatic() == false )
	    return false;	
	pBlock = _ifBlockList.Next();
    }
    return true;
}
