#ifndef _CEGOSYSTEMOBJECT_H_INCLUDED_
#define _CEGOSYSTEMOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSystemObject.h
// ------------------
// Cego system object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoSystemObject
// 
// Description: Description of all system tables like $table, $procedure, etc,
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoObjectManager.h"

class CegoSystemObject : public CegoObjectManager {
    
public:
    
    CegoSystemObject(CegoDatabaseManager *pDBMng);
    ~CegoSystemObject();

    void createSystemSpace(int tabSetId);
    bool objectExists(int tabSetId, const Chain& objectName, CegoObject::ObjectType type);
    void getObject(int tabSetId, const Chain& objectName, CegoObject::ObjectType type, CegoDecodableObject& oe);
    void getObjectWithFix(int tabSetId, const Chain& objectName, CegoObject::ObjectType type, CegoDecodableObject& oe, CegoBufferPage &bp);
    void getObjectList(int tabSetId, CegoObject::ObjectType type, ListT<Chain>& objList);

private:
        
    unsigned long _modId;
};
#endif
