#ifndef _CEGOTABLECACHE_H_INCLUDED_
#define _CEGOTABLECACHE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableCache.h
// ----------------
// Cego query cache interface defintion
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTableCache
//
// Description: Table Cache Management
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/HashT.h>
#include <lfcbase/Matcher.h>

#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoAttrDesc.h"
#include "CegoComparison.h"

// forward declaration
class CegoDatabaseManager;

class CegoTableCache {
    
public:
    
    CegoTableCache(int tabSetId, const Chain& cacheFilter, int maxSize, int maxEntry, int hashRange, CegoDatabaseManager *pDBMng);
    ~CegoTableCache();

    Element* getCacheInfo();
    Element* getCacheList();
    const Chain& getFilter() const;
    void setFilter(const Chain& cacheFilter);
    int getMaxSize() const;
    void setMaxSize(int maxSize);
    int getUsedSize() const;
    const int getNumTableCache() const;
    void invalidate(const Chain& tableName);
    CegoFieldValue*** claimEntry(const Chain& tableName, int& numRow, int& numCol);
    void releaseEntry(const Chain& tableName);
    bool matchEntry(const Chain& tableName);
    bool addEntry(const Chain& tableName, ListT< ListT<CegoFieldValue> >* pCache);
    void clean();
    void getTCLockStat(int& lockCount, unsigned long long &numRdLock, unsigned long long &numWrLock, unsigned long long &sumRdDelay, unsigned long long &sumWrDelay);
    
private:

    class TableCacheEntry {
	
    public:

	TableCacheEntry();
	TableCacheEntry(int tabSetId, const Chain& tableName);
	TableCacheEntry(int tabSetId, const Chain& tableName, ListT< ListT<CegoFieldValue> >* pCacheList);
	~TableCacheEntry();

	const int getSize() const;

	int getHashPos(int hashSize) const;
	
	int getNumRows() const;
	int getNumCols() const;

	const Chain& getTableName() const;
	int getTabSetId() const;

	CegoFieldValue*** claimCache();
	void releaseCache();
	
	unsigned long getHit() const;
	void incHit();

	bool cleanCache();
	
	TableCacheEntry& operator = ( const TableCacheEntry& tce);
        bool operator == ( const TableCacheEntry& tce);
	
	friend ostream& operator << (ostream& s, const TableCacheEntry& tce)
	{
	    s << "Cache " << tce._tabSetId << " " << tce._tableName;
	    return s;
	}

    private:
	
	Chain _tableName;
	int _tabSetId;
	CegoFieldValue*** _pCacheArray;
	int _numRow;
	int _numCol;
	int _numUsed;
	unsigned long _numHit;
	
    };

    void PR();
    void PW();
    void V();
    
    int _tabSetId;
    Chain _cacheFilter;
    int _maxEntry;
    int _maxSize;
    int _hashRange;
    int _usedSize;
    int _numFail;
    CegoDatabaseManager* _pDBMng;
    HashT<TableCacheEntry>* _pTableCache;
    Matcher* _pTableFilter;
};
#endif
