#ifndef _CEGOTABLEOBJECT_H_INCLUDED_
#define _CEGOTABLEOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableObject.h
// -----------------
// Cego table object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTableObject
// 
// Description: Cego table object structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoContentObject.h"

class CegoTableObject : public CegoContentObject {
    
public:
    
    CegoTableObject();
    CegoTableObject(const CegoTableObject& oe);
    CegoTableObject(int tabSetId, ObjectType type, const Chain& objName);
    CegoTableObject(int tabSetId, ObjectType type, const Chain& objName, const ListT<CegoField>& schema, const Chain& tabName);
    ~CegoTableObject();
    
    void setDataPageId(PageIdType pageId);
    PageIdType getDataPageId() const;
    void setLastDataPageId(PageIdType pageId);
    PageIdType getLastDataPageId() const;
    void setRefLastDataPageId(PageIdType pageId);
    PageIdType getRefLastDataPageId() const;
    void setMaxFid(int maxFid);
    int getMaxFid() const;
    int getEntrySize() const;
    void encode(char *buf) const;
    void decode(char *buf);
    bool isValid(); 
    void setSchema(const ListT<CegoField>& schema);   
    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(int defTabSetId) const;
    CegoContentObject* clone(bool isAttrRef = false);    
    Chain getInfo() const;
    
    CegoTableObject& operator = ( const CegoTableObject& oe);
    bool operator == ( const CegoTableObject& oe);
    
private:
    
    PageIdType _pageId;
    char* _pLastPageId;
    PageIdType _lastPageId;
    int _maxFid;
};
#endif
