#ifndef _CEGOADMSCREEN_H_INCLUDED_
#define _CEGOADMSCREEN_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmScreen.h  
// ---------------
// Cego admin screen interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdmScreen
// 
// Description: Cursor based administration database administration frontend
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <ctype.h>
#include <string.h>

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcbase/Datetime.h>
#include <lfcbase/SigHandler.h>
#include <lfcbase/Screen2.h>

#include "CegoAdminHandler.h"
#include "CegoXMLdef.h"

class CegoAdmScreen : public Screen2
{
    
public:
    
    CegoAdmScreen(CegoAdminHandler *pAH);
    ~CegoAdmScreen();
    
private:
    
    ///////////////////////
    // Buffer Pool Panel //
    ///////////////////////
    
    class BufferPool : public Screen2::Attribute {
    public:
    
	BufferPool(CegoAdminHandler* pAH, Screen2::Panel* pParent)
	    : Screen2::Attribute(pParent, Attribute::OVERLAY) {
	    _pAH = pAH;
	}
	
	bool doRefresh() { return true; }
	void refresh();
	
    private:
	
	CegoAdminHandler* _pAH;
    };
    
    ///////////////////////
    // Thread Pool Panel //
    ///////////////////////
    
    class ThreadPool : public Screen2::Select {
    public:
    
	ThreadPool(CegoAdminHandler* pAH, Screen2::Panel* pParent, const Chain& title);
	Screen2::Panel* onSelect(int selected);
	
    private:
	
	class DbPool : public Screen2::Grid {
	public:
	
	    DbPool(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	    ~DbPool();
	    Screen2::Panel* onSelect(int rowNum);
	    Screen2::Panel* onKey(int c, int rowNum);
	    
	    ListT< ListT<Chain> > getData() { return _threadTable; };
	    
	    bool doRefresh() { return true; }
	    void refresh();
	    
        private:
	    
	    class ThreadQuery : public Screen2::Grid {		
	    public:
		
		ThreadQuery(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~ThreadQuery();

		void setTitle(const Chain& title);
		void setHistory( ListT< ListT<Chain> >& queryHist);
		void setQueryFull( ListT<Chain>& queryFull);
		
		Screen2::Panel* onSelect(int rowNum);
		
		ListT< ListT<Chain> > getData() { return _queryTable; };
		
		bool doRefresh() { return false; }
		void refresh() {};
		
	    private:
		
		class QueryInfo : public Screen2::Message {
	        public:
		    
		    QueryInfo(Screen2::Panel* pParent) : Screen2::Message(pParent) {	
		    }
		    
		    void setQuery(const Chain& title, const Chain& msg, int numRow) {
			setInfo(title, msg, numRow);
		    }
	        };
		
	        QueryInfo* _pQueryInfo;
	        ListT< ListT<Chain> > _queryTable;
		
		ListT<Chain> _queryFull;		
		ListT<Chain> _querySchema;
		
		int format(const Chain& query, Chain& formatted);
		CegoAdminHandler *_pAH;
	    };

	    class ThreadAbort : public Screen2::Confirm {		
	    public:

		ThreadAbort(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~ThreadAbort();
		void setup( int threadId);
		Screen2::Panel* onConfirm();		
		Screen2::Panel* onCancel() { return _pParent; }
	       	      
	    private:

		CegoAdminHandler *_pAH;
		int _threadId;
	    };

	    void handleResult();
	    
	    ThreadQuery* _pQuery;
	    ThreadAbort* _pAbort;
	    ListT< ListT<Chain> > _threadTable;
	    ListT<Chain> _threadSchema;
	    CegoAdminHandler* _pAH;
	};
	
	class AdmPool : public Screen2::Grid {
	public:
	    
	    AdmPool(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	    ListT< ListT<Chain> > getData() { return _threadTable; };
	    bool doRefresh() { return true; }
	    void refresh();

	private:	    
	 
	    ListT< ListT<Chain> > _threadTable;
	    ListT<Chain> _threadSchema;
	    CegoAdminHandler* _pAH;
	};

      	class LogPool : public Screen2::Grid {
	public:
	    
	    LogPool(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	    ListT< ListT<Chain> > getData() { return _threadTable; };
	    bool doRefresh() { return true; }
	    void refresh();
	    
	private:

	    ListT< ListT<Chain> > _threadTable;
	    ListT<Chain> _threadSchema;
	    CegoAdminHandler* _pAH;
	};
      
	CegoAdminHandler* _pAH;
	DbPool* _pDb;
	AdmPool* _pAdm;
	LogPool* _pLog;	
    };

    ////////////////////
    // Tableset Panel //
    ////////////////////

    class TableSet : public Screen2::Grid {
	
    public:
	
	TableSet(CegoAdminHandler* pAH, Screen2::Panel* pParent, const Chain& title);	
	~TableSet();
	Screen2::Panel* onSelect(int selected);
	Screen2::Panel* onKey(int c, int rowNUm);
	ListT< ListT<Chain> > getData() { return _tsTable; };
	void refresh();
	bool doRefresh() { return true; };
	
    private:
	
	class Add : public Screen2::Form {
	public:
	    
	    Add(CegoAdminHandler* pAH, Screen2::Panel* pParent, const Chain& title);	    
	    ~Add();

	    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	    Screen2::Panel* onCancel() { return _pParent;   }
	    
	private:
	    
	    CegoAdminHandler* _pAH;	    
	};

	class Action : public Screen2::Select {
	public:
	    
	    Action(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	    ~Action();	    
	    void setTableSet(const Chain& tableSet, const Chain& tsState, const Chain& archMode);
	    Screen2::Panel* onSelect(int selected);	    
	    
	private:

	    class Edit : public Screen2::Form {
	    public:
		
		Edit(CegoAdminHandler* pAH, Screen2::Panel* pParent);	    
		~Edit();

		void setup(const Chain& tableSet);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
		Screen2::Panel* onCancel() { return _pParent;   }
		
	    private:

		Chain _tableSet;
		CegoAdminHandler* _pAH;		
	    };
	    
	    class Archlog : public Screen2::Grid {
	    public:
		
		Archlog(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Archlog();
		void setup(const Chain& tableSet, const Chain& archMode);
		Screen2::Panel* onSelect(int rowNum);
		Screen2::Panel* onKey(int c, int rowNum);
		ListT< ListT<Chain> > getData();
		void refresh();
		bool doRefresh() { return true; };
		
	    private:
		
		class Add : public Screen2::Form {
		public:
		    
		    Add(CegoAdminHandler* pAH, Screen2::Panel* pParent);		
		    ~Add();
		    
		    void setup(const Chain& tableSet);
		    Screen2::Panel* onConfirm(const ListT<Chain>& valList);			    
		    Screen2::Panel* onCancel();
		    
		private:
		    
		    Chain _tableSet;
		    CegoAdminHandler* _pAH;
		};

		class Conf : public Screen2::Form {
		public:
		    
		    Conf(CegoAdminHandler* pAH, Screen2::Panel* pParent);		
		    ~Conf();
		    
		    void setup(const Chain& tableSet, const Chain& archMode);
		    Screen2::Panel* onConfirm(const ListT<Chain>& valList);			    
		    Screen2::Panel* onCancel();
		    
		private:
		    
		    Chain _tableSet;
		    CegoAdminHandler* _pAH;
		};

		class Delete : public Screen2::Confirm {		    
		public:
		    
		    Delete(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		    ~Delete();
		    void setup(const Chain& tableSet, const Chain& al);
		    Screen2::Panel* onConfirm();		
		    Screen2::Panel* onCancel();
		    
		private:

		    Chain _tableSet;
		    Chain _al;
		    CegoAdminHandler *_pAH;
		};

		Add* _pAdd;
		Conf* _pConf;
		Delete* _pDelete;
		
		Chain _tableSet;
		Chain _archMode;
		ListT< ListT<Chain> > _alTable;
		ListT<Chain> _alSchema;
		CegoAdminHandler* _pAH;
	    };
	    
	    class Backup : public Screen2::Grid {
	    public:

		Backup(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		void setup(const Chain& tableSet);
		Screen2::Panel* onSelect(int rowNum);
		Screen2::Panel* onKey(int c, int rowNum);
		ListT< ListT<Chain> > getData();
		void refresh();
		
	    private:
		
		class Add : public Screen2::Confirm {
		public:
		
		    Add(CegoAdminHandler* pAH, Screen2::Panel* pParent);		    
		    void setup(const Chain& tableSet);
		    Screen2::Panel* onConfirm();
		    
		private:
		   
		    Chain _tableSet;
		    CegoAdminHandler* _pAH;
		};

		class Restore : public Screen2::Form {
		public:
	   
		    Restore(CegoAdminHandler* pAH, Screen2::Panel* pParent);		    
		    void setup(const Chain& tableSet, const Chain& buId);
		    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
		    
		private:
		    
		    Chain _buId;
		    Chain _tableSet;
		    CegoAdminHandler* _pAH;
		};

		Add* _pAdd;
		Restore* _pRestore;
		Chain _tableSet;
		bool _doRefresh;
		ListT< ListT<Chain> > _buTable;
		ListT<Chain> _buSchema;
		CegoAdminHandler* _pAH;
	    };
	
	    class FilePanel : public Screen2::Grid {
	    public:
		
		FilePanel(CegoAdminHandler* pAH, Screen2::Panel* pParent);	   	    
		void setup(const Chain& tableSet);
		Screen2::Panel* onSelect(int rowNum) { return this;  } 
		Screen2::Panel* onKey(int c, int rowNum);
		ListT< ListT<Chain> > getData() { return _fileTable; };
		void refresh();
		
	    private:
		
		class AddFilePanel : public Screen2::Form {
		public:
		    
		    AddFilePanel(CegoAdminHandler* pAH, Screen2::Panel* pParent);		    
		    void setup(const Chain& tableSet, const Chain& rootPath);
		    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
		    
		private:

		    Chain _rootPath;
		    Chain _tableSet;
		    CegoAdminHandler* _pAH;
		};
		
		AddFilePanel* _pAddFile;
		Chain _rootPath;
		Chain _tableSet;
		bool _doRefresh;
		ListT< ListT<Chain> > _fileTable;
		ListT<Chain> _fileSchema;
		CegoAdminHandler* _pAH;
	    };
	
 	    class XPort : public Screen2::Form {
	    public:	    

		XPort(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~XPort();

		void setup(const Chain& tableSet, bool isExport);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	 
	    private:

		bool _isExport;
		Chain _tableSet;
		CegoAdminHandler* _pAH;
	    };

	    class QueryCache : public Screen2::Form {
	    public:	    

		QueryCache(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~QueryCache();

		void setup(const Chain& tableSet);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	 
	    private:

		Chain _tableSet;
		CegoAdminHandler* _pAH;
	    };

	    class TableCache : public Screen2::Form {
	    public:	    

		TableCache(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~TableCache();

		void setup(const Chain& tableSet);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	 
	    private:

		Chain _tableSet;
		CegoAdminHandler* _pAH;
	    };

	    class Parameter : public Screen2::Form {
	    public:	    

		Parameter(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Parameter();

		void setup(const Chain& tableSet);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	 
	    private:

		Chain _tableSet;
		CegoAdminHandler* _pAH;
	    };
	    
	    class InfoPanel : public Screen2::Attribute {
	    public:	    

		InfoPanel(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		void setup(const Chain& tableSet);	    
		void refresh();           
		bool doRefresh() { return true; };
		
	    private:
		
		Chain _tableSet;
		CegoAdminHandler* _pAH;	    
	    };

	    class Drop : public Screen2::Confirm {
	    public:
		
		Drop(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Drop();
		void setup(const Chain& tableSet);	    
		Screen2::Panel* onConfirm();
		
	    private:

		Chain _tableSet;
		CegoAdminHandler* _pAH;	    
	    };
	    
	    Chain _tableSet;
	    Chain _archMode;

	    Edit* _pEdit;
	    FilePanel* _pFilePanel;
	    InfoPanel* _pInfoPanel;
	    
	    Archlog* _pArch;
	    Backup* _pBackup;
	    XPort* _pXPort;
	    Drop* _pDrop;
	    QueryCache* _pQueryCache;
	    TableCache* _pTableCache;
	    Parameter* _pParameter;
	    
	    CegoAdminHandler* _pAH;
	};
	
	Add* _pAdd;
	Action* _pAction;
	
	ListT<Chain> _tsSchema;
	ListT< ListT<Chain> > _tsTable;
	CegoAdminHandler* _pAH;	      
    };

    /////////////////
    // Role Panels //
    /////////////////

    class Role : public Screen2::Grid {
    public:

	Role(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	~Role();
	Screen2::Panel* onSelect(int selectedRow);
	Screen2::Panel* onKey(int c, int rowNum);
	ListT< ListT<Chain> > getData();
	void refresh();

    private :

	class Add : public Screen2::Form {
	public:
	    
	    Add(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	    ~Add();
	    Screen2::Panel* onConfirm(const ListT<Chain>& valList);	
	    Screen2::Panel* onCancel();
	    
	private:

	    CegoAdminHandler* _pAH;	    
	};
		
	class Action : public Screen2::Select {
	public:
	    
	    Action(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	    ~Action();
	    void setRole(const Chain& role);	    
	    Screen2::Panel* onSelect(int selected);
	    
	private:

	    class Perm : public Screen2::Grid {
	    public:

	        Perm(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Perm();
		void setup(const Chain& role);
		Screen2::Panel* onSelect(int rowNum);
		Screen2::Panel* onKey(int c, int rowNum);
		ListT< ListT<Chain> > getData();
		void refresh();
		bool doRefresh() { return true; };
		
	    private:

		class Edit : public Screen2::Form {		    
		public:
		    Edit(CegoAdminHandler* pAH, Panel* pParent);
		    ~Edit();

		    void clear();
		    void setup(const Chain& role);
		    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
		    Screen2::Panel* onCancel();
		    
		private:
		    
		    CegoAdminHandler* _pAH;
		    Chain _role;
		};

		Edit* _pEdit;
		ListT< ListT<Chain> >  _permTable;
		Chain _role;
		CegoAdminHandler* _pAH;
	    };

	    class Assign : public Screen2::Form {
	    public:	    

		Assign(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Assign();

		void setup(const Chain& role, const ListT<Chain> userList);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
		
	    private:
		
		Chain _role;
		CegoAdminHandler* _pAH;
	    };

	    class Delete : public Screen2::Confirm {
		
	    public:

		Delete(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Delete();
		void setup(const Chain& role);
		Screen2::Panel* onConfirm();		
		Screen2::Panel* onCancel();
	       	      
	    private:

		Chain _role;
		CegoAdminHandler *_pAH;

	    };

	    Chain _role;
	    Perm* _pPerm;
	    Delete* _pDelete;
	    Assign* _pAssign;
	    CegoAdminHandler* _pAH;
	};
		
	ListT< ListT<Chain> > _roleTable;
	ListT<Chain> _roleSchema;

	Add* _pAdd;
	Action* _pAction;

	CegoAdminHandler* _pAH;
    };

    /////////////////
    // User Panels //
    /////////////////
    
    class User : public Screen2::Grid {
    public:
	
	User(CegoAdminHandler* pAH, Screen2::Panel* pParent);
	~User();
	Screen2::Panel* onSelect(int selectedRow);
	Screen2::Panel* onKey(int c, int rowNum);
	ListT< ListT<Chain> > getData();
	void refresh();
	bool doRefresh() { return true; };

    private:

	SetT<Chain> roleString2Set(const Chain& roleString);
	    
	class Add : public Screen2::Form {
	public:
	    
	    Add(CegoAdminHandler* pAH, Screen2::Panel* pParent);	    
	    ~Add();
	    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	    Screen2::Panel* onCancel();
	    
	private:
	    
	    CegoAdminHandler* _pAH;	    
	};

	class Action : public Screen2::Select {
	public:
	    
	    Action(CegoAdminHandler* pAH, Screen2::Panel* pParent);	
	    ~Action();	
	    void setup(const Chain& user, const SetT<Chain>& userRoleSet, bool isTrace);
	    Screen2::Panel* onSelect(int selected);
	    
	private:
		
	    class Passwd : public Screen2::Form {
	    public:
		
		Passwd(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Passwd();
		void setUser(const Chain& user);		
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);		
		Screen2::Panel* onCancel();
		
	    private:
		
		Chain _user;
		CegoAdminHandler* _pAH;		
	    };

	    class Assign : public Screen2::Form {
	    public:
		
		Assign(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Assign();

		void setup(const Chain& user, const SetT<Chain> roleSet, bool isAssign);
		Screen2::Panel* onConfirm(const ListT<Chain>& valList);
		
	    private:
		
		bool _isAssign;
		Chain _user;
		CegoAdminHandler* _pAH;
	    };

	    class Delete : public Screen2::Confirm {		
	    public:

		Delete(CegoAdminHandler* pAH, Screen2::Panel* pParent);
		~Delete();
		void setup(const Chain& role);
		Screen2::Panel* onConfirm();		
	       	      
	    private:

		Chain _user;
		CegoAdminHandler *_pAH;
	    };

	    bool _isTrace;
	    Chain _user;
	    SetT<Chain> _userRoleSet;
	    Delete* _pDelete;
	    Assign* _pAssign;
	    Passwd* _pPwd;
	    CegoAdminHandler* _pAH;
	};
	
	CegoAdminHandler* _pAH;
	Add* _pAdd;
	Action* _pAction;
	
	ListT< ListT<Chain> > _userTable;
	ListT<Chain> _userSchema;
    };

    /////////////////
    // Setup Panel //
    /////////////////

    class Setup : public Screen2::Select {
    public:

	Setup(CegoAdmScreen* pScreen, CegoAdminHandler* pAH, Screen2::Panel* pParent, const Chain& title);
	~Setup();	
	Screen2::Panel* onSelect(int selected);
      
    private:
	
	class LogMng : public Screen2::Form {
	public:
	
	    LogMng(CegoAdminHandler* pAH, Screen2::Panel* pParent, const Chain& title);
	    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	    void setup();
	private:
	    
	    CegoAdminHandler* _pAH;	    
	};
	
	class BackupMng : public Screen2::Form {
	public:
	    
	    BackupMng(CegoAdminHandler* pAH, Screen2::Panel* pParent, const Chain& title);
	    Screen2::Panel* onConfirm(const ListT<Chain>& valList);
	    void setup();
	    
	private:
	    
	    CegoAdminHandler* _pAH;	    
	};

	class Refresh : public Screen2::Select {
	public:
	    
	    Refresh(Screen2* pScreen, Screen2::Panel* pParent);
	    Screen2::Panel* onSelect(int selected);
	    
	private:
	    
	    Screen2* _pScreen;
	};
	
	LogMng* _pLogMng;
	BackupMng* _pBackupMng;
	Refresh* _pRefresh;	
    };
    
    Menu* _pMenu;
    BufferPool* _pBufferPool;
    ThreadPool* _pThreadPool;
    TableSet* _pTableSet;
    User* _pUser;
    Role* _pRole;   
    Setup* _pSetup;
    
    CegoAdminHandler* _pAH;
};
#endif














