#ifndef _CEGOLOGTHREADPOOL_H_INCLUDED_
#define _CEGOLOGTHREADPOOL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogThreadPool.h  
// ---------------------
// Cego log threadpool class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoLogThreadPool
// 
// Description: Thread pool implementation for log message handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Logger.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>

// CEGO INCLUDES
#include "CegoLogThread.h"

class CegoLogThread;

class CegoLogThreadPool : public Thread {
    
public:
    
    enum ThreadState { READY, BUSY, CONNECTED };
    
    CegoLogThreadPool();
    CegoLogThreadPool(CegoDatabaseManager *pDBMng);
    CegoLogThreadPool(int poolLimit, CegoDatabaseManager *pDBMng);
    ~CegoLogThreadPool();
    
    int getPoolLimit() const;
    void* job(void* arg);
    void getThreadInfo(int i, unsigned long long& numRequest, unsigned long long& threadLoad, ThreadState& state, Chain& action);
    void setState(int i, ThreadState state);
    void setTid(int i, unsigned long long tid);
    void incNumRequest(int i);
    void addThreadIdle(int i, unsigned long long usec);
    void dispatch();
    NetHandler* nextRequest();
    bool isTerminated();
    void getLockStat(Chain& lockName, int& lockCount, unsigned long long &numRdLock, unsigned long long &numWrLock, unsigned long long &sumRdDelay, unsigned long long &sumWrDelay);

private:

    void copyLog(const Chain& tableSet, const Chain& logFileName, const Chain& archLogPath);
    void shiftRedoLogs();
    void lockQueue();
    void unlockQueue();
	
    unsigned long long* _threadId;
    unsigned long long* _numRequest;
    ThreadState* _threadState;
    unsigned long long* _threadIdle[THRMNG_NUMLOADSAMPLE];
    unsigned long long* _threadLoad;
    int _samplePos;
    CegoLogThread** _threadList;
    int _poolLimit;
    Chain _logHostName;
    int _logPortNo;
    bool _terminated;
    bool _joined;
    ListT<NetHandler*> _requestQueue;
    CegoDatabaseManager* _pDBMng;

    unsigned long _modId;
};
#endif
