///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcObject.cc 
// -----------------
// Cego procedure object implementation
//     
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcObject
//
// Description: Container class for Cego stored procedures
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Tokenizer.h>

// cego includes
#include "CegoProcObject.h"
#include "CegoXMLdef.h"

#include <string.h>
#include <stdlib.h>

CegoProcObject::CegoProcObject()
{
}

CegoProcObject::CegoProcObject(const CegoProcObject& po)  : CegoDecodableObject(po)
{
    _procText = po._procText;
}

CegoProcObject::CegoProcObject(const Chain& procName, int tabSetId) : CegoDecodableObject(CegoObject::PROCEDURE, procName, tabSetId)
{
}

CegoProcObject::CegoProcObject(int tabSetId, const Chain& procName, const Chain& procText) : CegoDecodableObject(CegoObject::PROCEDURE, procName, tabSetId)
{
    _procText = procText;
}

CegoProcObject::~CegoProcObject()
{   
}

int CegoProcObject::getEntrySize() const
{
    int entrySize = CegoObject::getBaseSize();
    entrySize += _procText.length() + 1;
    return entrySize;
}

void CegoProcObject::encode(char *buf) const
{
    char* bufPtr = buf;
    int entrySize = getEntrySize();
    CegoObject::encodeBase(bufPtr, entrySize);
    bufPtr += CegoObject::getBaseSize();
    memcpy (bufPtr, (char*)_procText , _procText.length() + 1);
}

void CegoProcObject::decode(char *buf)
{
    char* bufPtr = buf;
    int size;
    CegoObject::decodeBase(bufPtr, size);
    bufPtr += CegoObject::getBaseSize();
    _procText = Chain(bufPtr);
}

CegoProcObject& CegoProcObject::operator = ( const CegoProcObject& po)
{
    CegoObject::operator=(po);

    _procText = po._procText;
    return (*this);
}

bool CegoProcObject::operator == ( const CegoProcObject& po)
{
    return CegoObject::operator==(po);
}

const Chain& CegoProcObject::getProcText() const
{
    return _procText;
}

Chain CegoProcObject::getInfo() const
{
    Chain s;   
    s = Chain("Proc Text: ") + _procText + Chain("\n");
    return s;
}
