///////////////////////////////////////////////////////////////////////////////
//
// NetClient.cc
// -------------
// file class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2019 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>

#include "../src/Exception.h"
#include "../src/Timer.h"
#include "../src/Net.h"
#include "../src/Chain.h"

int main(int argc, char **argv) 
{ 
    
    try { 
	
	// int msgsize=Chain(argv[1]).asInteger(); 
       	
	Net n(1024, 10, 8192); 
	NetHandler* pN; 

	srand(time(NULL));

	for ( int x =0; x<1000; x++)
	{
	    pN = n.connect(Chain("bigmac.local"), Chain("2000")); 

	    
	    int dataSize = rand() % 8000 + 1;
	     
	    char* data = (char*)malloc(dataSize);
	    for ( int i = 0; i< dataSize; i++)
		data[i]=(char)rand() % 200 + 1;
	    
	    cout << "Sending " << dataSize << " byte ..." << endl;
	    // cout << "Data=" << data << endl;
	    
	    pN->setMsg(data, dataSize);
	    

	    /*
	    Chain data("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"); 
	    
	    pN->setMsg(data, data.length()); 
	    */
	    
	    
	    cout << "Write msg .." << endl;
	    pN->writeMsg();
	    
	    // cout << "Read msg .." << endl;
	    // pN->readMsg();
	    // cout << "Msg read : " << pN->getMsg() << endl;
	    
	    free ( data );
	}
    } 
    catch (Exception e) 
    { 
	e.print(); 	
    } 
} 


