/////////////////////////////////////////////////////////////////////////////// 
// 
// PagTest.cc 
// ------------- 
// Pager class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Pager.h" 

#include <locale.h> 

int main(int argc, char **argv) 
{ 
    try 
    { 
        ListT<Chain> schema;

	schema.Insert("First:30");
	schema.Insert("SecondColumn:auto");
	schema.Insert("Third:10");
	
        ListT< ListT<Chain> > outData; 

        for ( int i=1; i<= 100; i++) 
        { 
             ListT<Chain> outRow;
             outRow.Insert(Chain(i) + Chain(" Alpha") ); 
             outRow.Insert(Chain("Beta") + Chain(i) + Chain("BetaX")); 
             outRow.Insert("Gamma1Gamma2Gamma3"); 
             outData.Insert(outRow); 
        } 

        for ( int i=1; i<= 10; i++) 
        { 
             ListT<Chain> outRow;
             outRow.Insert(Chain(i) + Chain(" Alpha") ); 
             outRow.Insert(Chain("Beta") + Chain(i) + Chain("BetaX")); 
             outRow.Insert("Gamma1\nGamma2\nGamma3"); 
             outData.Insert(outRow); 
        } 
	
	for ( int i=1; i<= 10; i++) 
        { 
             ListT<Chain> outRow;
             outRow.Insert(Chain(i) + Chain(" Alpha") ); 
             outRow.Insert(Chain("Beta") + Chain(i) + Chain("\nBetaX")); 
             outRow.Insert("Gamma1\nGamma2\nGamma3\nGamma4\nGamma5"); 
             outData.Insert(outRow); 
        } 
	
	Pager pag; 
	pag.managePage(Chain("The Page"), schema, outData);

    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    return 0; 

} 
