///////////////////////////////////////////////////////////////////////////////
//                                                         
// TokenTest.cc
// -------------
// tokenizer class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2002 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Chain.h"
#include "../src/Tokenizer.h"

int main(int argc, char **argv)
{


    int numCheck = 1;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
      
	
	Chain s1("AAA@BB!@CC");       
	Tokenizer t(s1, "@", '!');
	
	Chain token;
	while (t.nextToken(token) == true)
	{
	    
	    cout << "t=" << token << endl;
	    cout << "Ahead=" << t.numAhead() << endl;

	    if ( t.rawRead(token, 4) )
	    {
		cout << "Raw read t=" << token << endl;
	    }
	    
	}

	
	cout << "ok " << checkCount << " - tokenizer test" << endl;
	checkCount++;

      	
    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;  

}

