#ifndef _PAGER_H_INCLUDED_ 
#define _PAGER_H_INCLUDED_ 
/////////////////////////////////////////////////////////////////////////////// 
// 
// Pager.h 
// --------- 
// Curses based pager interface definition 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017 Bjoern Lemke 
// 
// INTERFACE MODULE 
// 
// Class: CegoAdmMon 
// 
// Description: Description: Cursor based monitor 
// 
// Status: CLEAN 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include <ctype.h> 
#include <string.h> 

#ifndef LFCNOCURSES 

#ifdef HAVE_MINGW 
#include <ncurses/ncurses.h> 
#else 
#include <ncurses.h> 
#endif 

#endif 

#include "Chain.h" 
#include "ListT.h" 
#include "Datetime.h" 
#include "SigHandler.h" 

#define MON_TIMEOUT 0 
#define MON_SELECT 1 
#define MON_LEAVE 2 

class Pager : public SigHandler { 

public: 

    Pager(); 
    ~Pager(); 

    void managePage(const Chain& title, const ListT<Chain>& schema, const ListT< ListT<Chain> > & outData); 

private: 

    void nextRow();
    void prevRow();

    void firstRow();
    void lastRow();
    
    void writeHeader(); 
    void writePage();
    void writeFooter();
    void writeDebug() ;
    void refreshRow(int dataRow, int pageRow);
    void getAttrSpec(int colPos, const Chain& s, Chain& attr, int& len);
    void sigCatch(int sig);

    void formatData(const ListT< ListT<Chain> > & outData); 

    ListT<Chain> _schema;
    ListT<int> _outLen;
    ListT<int> _rowHeight;
    ListT< ListT<Chain> > _outData;
	
    Chain _title;
    Chain _debug;
    
    int _rows;
    int _cols;

    int _curStat;

    int _pdi; // previous data idx
    int _pci; // previous cursor idx
    int _ndi; // next data idx
    int _nci; // next cursor
    
    int _rowIdx;
    int _rowSelected;
    int _vStart;
    int _offset;
    

}; 

#endif
