///////////////////////////////////////////////////////////////////////////////
//                                                         
// Semaphore.cc
// ------------
// semaphore memory class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: Semaphore
// 
// Description: All operations on system semaphore resources
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// BASE INCLUDES
#include "Exception.h"
#include "Semaphore.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if ( ! HAVE_STRUCT_SEMUN )
union semun {
    int val;                    /* value for SETVAL */
    struct semid_ds *buf;       /* buffer for IPC_STAT, IPC_SET */
    unsigned short int *array;  /* array for GETALL, SETALL */
    struct seminfo *__buf;      /* buffer for IPC_INFO */
};
#endif

#ifdef HAVE_MINGW
#else

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

#endif

Semaphore::Semaphore(int key)
{

#ifdef HAVE_MINGW
#else

    if ( (_id = semget(key, 1, IPC_CREAT | 0000777)) == -1)
    {
	throw Exception(EXLOC, "semget system error");
    }
#endif   
}

Semaphore::~Semaphore()
{
}

void Semaphore::init()
{
#ifdef HAVE_MINGW
#else
    union semun arg; 
    
    arg.val=1;
    
    if ( semctl(_id, 0, SETVAL, arg) == -1)
    {
	// perror("semctl");
	throw Exception(EXLOC, "semctl system error");
    }
#endif
}

void Semaphore::destroy()
{
#ifdef HAVE_MINGW
#else

    if ( semctl(_id, 0, IPC_RMID)  == -1)
    {
	throw Exception(EXLOC, "semctl system error");
    }
#endif
}

int Semaphore::getValue()
{
#ifdef HAVE_MINGW
    return 0;
#else
    return semctl(_id, 0, GETVAL);
#endif
}

void Semaphore::P()
{
#ifdef HAVE_MINGW
#else
    struct sembuf op;

    op.sem_num = 0;
    op.sem_op  = -1;
    op.sem_flg = 0;
    
 
    // cout << "P(" << _id << ")" << endl;

    if ( semop(_id, &op, 1) == -1)
    {
	// perror("semop:");
	throw Exception(EXLOC, "semop system error");
    }
#endif
}

void Semaphore::V()
{
#ifdef HAVE_MINGW
#else
    struct sembuf op;
    
    op.sem_num = 0;
    op.sem_op  = 1;
    op.sem_flg = 0;
    
    // cout << "V(" << _id << ")" << endl;

    if ( semop(_id, &op, 1) == -1)
    {
	throw Exception(EXLOC, "semop system error");
    }
#endif
}
