/////////////////////////////////////////////////////////////////////////////// 
// 
// PagTest.cc 
// ------------- 
// Pager class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Pager.h" 

#include <locale.h> 

class MyPager : public Pager
{

    
public:
    
    MyPager(const Chain& title) : Pager(title) {
	_hasData=false;
    }
    
    ~MyPager() {

    }
    
    bool execute(const Chain& cmd, Chain& msg) {

	if ( cmd != Chain("fail") )
	{
	    msg = Chain("Command is : ") + cmd;
	    if ( cmd == Chain("data") || cmd == Chain("empty") )
		_hasData= true;
	    else
		_hasData=false;
	    _cmd = cmd;
	    return true;
	}
	else
	{
	    msg = Chain("Here comes the very log error message with several words <") + cmd + Chain(">");
	    return false;	    
	}
    }

    bool hasData() {
	return _hasData;
    }
    
    ListT<Chain> getSchema() { 

	ListT<Chain> schema;

	schema.Insert("First:30");
	schema.Insert("SecondColumn:auto");
	schema.Insert("Third:15");
	schema.Insert("Fourth:40");

	return schema;

    }
    

    ListT< ListT<Chain> > getData() {
	
	
	ListT< ListT<Chain> > outData; 
	
	if ( _cmd != Chain("empty")  )
	{
	    for ( int i=1; i<= 20; i++) 
	    { 
		ListT<Chain> outRow;
		outRow.Insert(Chain(i) + Chain(" Alpha") ); 
		outRow.Insert(Chain("Beta") + Chain(i) + Chain("BetaX")); 
		outRow.Insert("Gamma1Gamma2\nGamma3");
		outRow.Insert("A long column XXXXXX with more data"); 
		outData.Insert(outRow); 
	    }
	    
	    for ( int i=1; i<= 3; i++) 
	    { 
		ListT<Chain> outRow;
		outRow.Insert(Chain(i) + Chain(" Bingo") ); 
		outRow.Insert(Chain("HalloBeta") + Chain(i) + Chain("BetaX")); 
		outRow.Insert("XXXX\nERNA");
		outRow.Insert("A long column XXXXXX with more data"); 
		outData.Insert(outRow); 
	    }
	}
	return outData;

    }
    
private:

    Chain _cmd;
    bool _hasData;
    
};


int main(int argc, char **argv) 
{ 
    try 
    { 
     	   
	MyPager pag(Chain("The Page"));

	pag.readHistory("pager.hist");
	
	pag.manage();

	pag.writeHistory("pager.hist");
    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    return 0; 

} 
