#ifndef _BIGDECIMAL_H_INCLUDED_
#define _BIGDECIMAL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// BigDecimal.h
// ------------
// BigDecimal class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
// 
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// INTERFACE MODULE
//
// Class: BigDecimal
// 
// Description: BigDecimal class arbitrary decimal values
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Chain.h"

class BigDecimal {

public:

    enum RoundMode { UP, DOWN, HALFUP, HALFDOWN };
    
    BigDecimal();

    BigDecimal(const Chain& s);
    ~BigDecimal();    

    BigDecimal abs() const;
    bool isPositive() const;
    void negate();

    BigDecimal add(const BigDecimal& d) const;
    BigDecimal sub(const BigDecimal& d) const;
    BigDecimal mul(const BigDecimal& d) const;
    BigDecimal div(const BigDecimal& d) const;
    BigDecimal scaleTo(int scale, RoundMode mode = DOWN ) const;

    int getScale() const;
    int length() const;
    
    Chain toChain() const;
    
    BigDecimal& operator = ( const BigDecimal& d);
    BigDecimal& operator += ( const BigDecimal& d);
    BigDecimal& operator -= ( const BigDecimal& d);
    bool operator == ( const BigDecimal& d) const;
    bool operator != ( const BigDecimal& d) const;
    bool operator < ( const BigDecimal& d) const;
    bool operator > ( const BigDecimal& d) const;
    bool operator <= ( const BigDecimal& d) const;
    bool operator >= ( const BigDecimal& d) const;

    friend BigDecimal operator + ( const BigDecimal& d1, const BigDecimal& d2);
    friend BigDecimal operator - ( const BigDecimal& d1, const BigDecimal& d2);
    friend BigDecimal operator * ( const BigDecimal& d1, const BigDecimal& d2);
    friend BigDecimal operator / ( const BigDecimal& d1, const BigDecimal& d2);
    friend ostream& operator << (ostream& s, const  BigDecimal& d);
    
private:

    BigDecimal(const Chain& val, int scale);
    
    Chain mulDec(const Chain& val, int dim) const;
    int compAbs(const BigDecimal& d) const;
    
    bool _isPositive;
    Chain _val;
    int _scale;
};
#endif



