///////////////////////////////////////////////////////////////////////////////
//                                                         
// Tokenizer.cc
// ------------
// Tokenizer implementation module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//                                                         
// IMPLEMENTATION MODULE
//
// Class: Tokenizer
//
// Description: Splitting a string into tokens
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// BASE INCLUDES
#include "Chain.h"
#include "Tokenizer.h"
#include "Exception.h"

Tokenizer::Tokenizer(const Chain& tokenStream, const Chain& sep, char esc)
{
    _tokenStream = tokenStream;
    _streamBuf = (char*)_tokenStream;
    _bufLen = _tokenStream.length();
    _isLocal = true;
    _sep = sep;
    _esc = esc;
    _lower = 0;
    _upper = 0;
}

Tokenizer::Tokenizer(char* buf, int len, const Chain& sep, char esc)
{
    _streamBuf = buf;
    _bufLen = len;
    _isLocal = false;
    _sep = sep;
    _esc = esc;
    _lower = 0;
    _upper = 0;
}

Tokenizer::~Tokenizer()
{
}

bool Tokenizer::nextToken(Chain& token)
{

    if ( _bufLen <= _upper)
	return false;

    int si;

    bool sepFound = true;

    // skip through sep

    while (sepFound == true)
    {
	sepFound = false;

	si=0;
	while (sepFound == false && si<_sep.length()-1)
	{
	    char c;
	    c = _sep[si];

	    if (_streamBuf[_upper] == c)
	    {
		sepFound = true;
	    }
	    si++;
	}
	if (sepFound == true)
	{
	    _upper++;
	}
    }

    _lower = _upper;

    while (sepFound  == false && _streamBuf[_upper])
    {
	if ( _streamBuf[_upper] == _esc )
	{
	    _upper++;
	    if ( _streamBuf[_upper] )
	    {
		if ( checkSeparator() )
		{
		    _upper++;
		}
	    }
	    else
		throw Exception(EXLOC, Chain("Unexpected end of token steam"));
	    
	}
	else if ( _streamBuf[_upper] )
	{	    
	    sepFound = checkSeparator();
	    
	    if (sepFound == false)
	    {
		_upper++;
	    }
	}
    }

    if (_lower == _upper)
    {
	return false;
    }
    
    token = Chain(_streamBuf + _lower, _upper - _lower);
    
    // token = _tokenStream.subChain(_lower+1, _upper);

    _lower = _upper;
    
    return true;
}

bool Tokenizer::checkSeparator()
{
    bool sepFound=false;
    int si=0;
    while ( sepFound == false  && si<_sep.length()-1)
    {			      
	char c;	
	c = _sep[si];
	if (_streamBuf[_upper] == c)
	{
	    sepFound = true;
	}
	si++;
    }
    return sepFound;
}
    
bool Tokenizer::getTail(Chain& token)
{
  if ( _bufLen > _lower+1 )
  {
      token = Chain(_streamBuf + _lower, _bufLen - _lower);
      return true;
  }
  return false;

}

void Tokenizer::skip(int n)
{
    _upper += n;
    _lower = _upper;
}

bool Tokenizer::rawRead(Chain& token, int n)
{    
    if ( _bufLen < _upper + n)
	return false;

    _upper += n;
    token = Chain(_streamBuf + _lower, _upper - _lower);
    _lower = _upper;
    
    return true;
}

int Tokenizer::numAhead() const
{
    return _bufLen - _lower - 1;
}

void Tokenizer::reset()
{
    _lower = 0;
    _upper = 0;
}

void Tokenizer::reset(char* buf, int len)
{
    _streamBuf = buf;
    _bufLen = len;
    _isLocal = false;
    _lower = 0;
    _upper = 0;
}

Tokenizer& Tokenizer::operator = (const Tokenizer& t)
{
    _tokenStream = t._tokenStream;
    _streamBuf = t._streamBuf;
    _bufLen = t._bufLen;
    _sep = t._sep;
    _esc = t._esc;
    _lower = t._lower;
    _upper = t._upper;
    return (*this);
}
