///////////////////////////////////////////////////////////////////////////////
// 
// TreeTest.cc - Testing the SetT template
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2006 by Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// Description: Testing the TreeT class
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/Chain.h"
#include "../src/TreeT.h"

#include <stdlib.h>
#include <unistd.h>

ostream& operator << (ostream& s, TreeT<int>& x)
{

     int* pElement = x.First();
  
     s << "{";
     
     while (pElement)
     {      
	  s << *pElement ;
	  pElement = x.Next(); 
	  if (pElement)
	       s << ",";
     }
     s << "}";
     
     return s;
  
}

typedef TreeT<int> IntTree;


ostream& operator << (ostream& s, TreeT<IntTree>& x)
{
     TreeT<int>* pElement = x.First();
  
     s << "{";
     
     while (pElement)
     {
	  s << *pElement ;
	  pElement = x.Next(); 
	  if (pElement)
	       s << ",";
     }
     s << "}";
     
     return s;
     
}

int main(int argc, char **argv)
{


    int numCheck = 2;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
	
	srand(42);

	/*
	TreeT<int> bTree;
	
	bTree.Insert(1);
	bTree.Insert(3);
	bTree.Insert(2);
      
	bTree.Insert(1);

	*/

	TreeT<Chain> bTree;
	
	bTree.Insert(Chain("Alpha"));
	bTree.Insert(Chain("Beta"));
	bTree.Insert(Chain("Beta"));
      
	// bTree.Insert(Chain("Gamma"));
	
	
	// cout << "Size = " << bTree.Size() << endl;

	// exit(0);
	
	unsigned long  count = 100;
	while (count)
	{	
	    
	    int elem = rand() % (100 * count);
	    
	    bTree.Insert(elem);
	    
	    if (( count % 30)  == 0)
	    {
		bTree.Empty();
	    }
	    
	    count--;	
	}
	
	bTree.Size();
	

	cout << "ok " << checkCount << " - base tree" << endl;
	checkCount++;

	int count1=10;
	int count2=30;
	
	TreeT<IntTree> *powerTree = new TreeT<IntTree>;    
	unsigned long i = count1;
	
	while (i)
	{
	    TreeT<int> baseTree;
	    unsigned long j = count2;
	    
	    while (j)
	    {	
		int elem = rand() % count2;
		baseTree.Insert(elem);
		j--;	
	    }
	    
	    powerTree->Insert(baseTree);
	    i--;	
	}
	
	
	IntTree *p = powerTree->First();
	powerTree->Remove(*p);
	
	p = powerTree->First();      
	powerTree->Remove(*p);
	
	p = powerTree->First();
	powerTree->Remove(*p);

	cout << "ok " << checkCount << " - power tree" << endl;
	checkCount++;
	
    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;
    
}



