///////////////////////////////////////////////////////////////////////////////
//                                                         
// Directory.cc
// ------------
// Directory class implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// IMPLEMENTATION MODULE
//
// Class: Directory
//
// Description: Utility class for directory operations
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

// BASE INCLUDES
#include "Exception.h"
#include "Chain.h"
#include "Directory.h"
#include "Tokenizer.h"

// SYSTEM INCLUDES
#include <unistd.h>
#include <string.h>
#include <fcntl.h>

#include <sys/param.h>
#include <sys/stat.h>
#include <dirent.h>
#include <errno.h>

Directory::Directory()
{
}

Directory::Directory(const Chain&  str)
{
    _dir = str;
}

Directory::~Directory()
{
     
}

bool Directory::exists()
{
    struct stat sb;
    int ret = ::stat(_dir, &sb);
    
    if ( ret == -1 ) 
    {
	if ( errno == ENOENT )
	    return false;
	else
	{
	    Chain msg = Chain("Cannot stat directory ") +  _dir + Chain(" : ") + Chain(strerror(errno));
	    throw Exception(EXLOC, msg);
	    
	}
    }
    return true;
}	  

void Directory::create()
{

#ifdef HAVE_MINGW
    int ret = ::mkdir(_dir);
#else
    mode_t m = 0755;
    int ret = ::mkdir(_dir, m);
#endif
    
    if ( ret == -1 ) 
    {
	Chain msg = Chain("Cannot create directory ") +  _dir + Chain(" : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
	
    }
    return;
}

ListT<Chain> Directory::list() const
{
    ListT<Chain> dirList;

    DIR *dp;
    struct dirent *ep;     
    dp = opendir (_dir);
    
    if (dp != NULL)
    {
	while ( ( ep = readdir (dp) ) != NULL )
	{
	    dirList.Insert( Chain(ep->d_name));
	}
	closedir (dp);
    }
    else
    {
	Chain msg = Chain("Cannot list directory ") +  _dir + Chain(" : ") + Chain(strerror(errno));
	throw Exception(EXLOC, msg);
    }

    return dirList;
}

void Directory::setCurrent()
{     
     char buf[MAXPATHLEN];

     if ( ::getcwd(buf, MAXPATHLEN) == NULL )
     {
	 Chain msg = "Cannot get working directory";
	 throw Exception(EXLOC, msg);
     }	  

     _dir = Chain(buf);
}

const Chain& Directory::getName() const
{
    return _dir;
}
